/*
 * cs101 UserDialog utility
 * $Id: UserDialog.java,v 1.2 1998/06/03 21:45:32 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

/**
 * cs101.util.UserDialog manages a top level query dialog box to get a
 * username.  To display the dialog box, use ask(); to extract the username,
 * use getUserName().<p>
 *
 * @see QueryDialog
 * @see #ask
 * @see #getUserName
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: UserDialog.java,v 1.2 1998/06/03 21:45:32 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public class UserDialog {
  
    protected QueryDialog qd;
    protected String[] answers, questions;

    /**
     * Creates the dialog information.
     * To show the dialog, call ask().
     * To retrieve information, use int getPort().
     */
     public UserDialog() {
	 this.questions = new String[1];
	 this.questions[0] = "User Name: ";
	 this.answers = new String[1];
	 this.answers[0] = "";
	 this.qd = new QueryDialog("Please enter a user name.", 
				   this.questions,
				   this.answers);
    }

    /**
     * Actually display the query dialog and get the answers from the user.
     *
     * @see getPort()
     */ 
    public synchronized void ask() {
	this.answers = this.qd.ask();
    }

    /**
     * Return the port number from the user.  Not guaranteed to be sensible
     * if ask hasn't aready been called.
     *
     * @see ask()
     */
    public synchronized int getUserName() {
	try {
	    return Integer.parseInt( this.answers[0] );
	} catch ( NumberFormatException e ) {
		throw new RuntimeException("Bad user name: '"+answers[0]+"'");
	}
    }
}
    
/*
 * $Log: UserDialog.java,v $
 * Revision 1.2  1998/06/03 21:45:32  tparnell
 * added header, javadoc, and logging
 *
 */
    











