/*
 * cs101 String utilities
 * $Id: StringUtils.java,v 1.1 1998/03/13 22:18:23 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

/**
 * cs101.util.StringUtils implements some string utility functions.
 * It is intended as a library class, i.e., all methods are static.
 *
 * @author  Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: StringUtils.java,v 1.1 1998/03/13 22:18:23 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public final class StringUtils {
   /**
    * A string containing the non-word characters a user might
    * reasonably be expected to type at a semi-standard American
    * keyboard.  Suitable for using as delimiters for
    * java.util.StringTokenizer. 
    * 
    * @see    java.util.StringTokenizer
    */
    public static final String nonWordChars 
                = "!@#$%^&*()_-+=|`~<>,.?/:;\"\' \t\n\b\f\r{}[]\\";

   /**
    * Determines whether its argument is a word or a delimiter as
    * defined by a java.util.StringTokenizer when initialized with
    * StringUtils.nonWordChars as a delimiter string.
    *
    * @param    word      String to be tested for "wordness".
    *
    * @return  false if word is one of the delimiters in
    *               StringUtils.nonWordChars, true otherwise.
    *
    * @see    java.util.StringTokenizer
    * @see    #nonWordChars
    * @see    java.lang.String
    */
    public static final boolean wordP (String word) {
        return ( (! (word.length() == 1)) 
                 || (StringUtils.nonWordChars.indexOf(word.charAt(0)) == -1 ));
    }

   /**
    * Determines whether the first character of its argument word is
    * upper case.
    *
    * @param    word      String to be checked for capitalization.
    *
    * @return  true if first character is upper case.
    *
    * @see    java.lang.Character#isUpperCase
    * @see    java.lang.String#charAt
    */
    public static final boolean capitalizedP (String word) {
        return Character.isUpperCase(word.charAt(0));
    }


   /**
    * Determines whether all of the characters in its argument word are
    * upper case.
    *
    * @param    word      String to be checked for capitalization.
    *
    * @return  true if all characters are is upper case.
    *
    * @see    java.lang.Character#isLowerCase
    * @see    java.lang.String#charAt
    * @see    java.lang.String#length
    */
    public static final boolean allUpperCaseP (String word) {
        for (int i = 0; i < word.length(); i++) {
            if (Character.isLowerCase(word.charAt(i))) {
                return false;
            }
        }
        return true;
    }

   /**
    * Constructs a new string identical to its argument, but with the
    * first character replaced by its upper case equivalent.
    *
    * @param    word      String to be capitalized.
    *
    * @return  the new, capitalized String.
    *
    * @see    java.lang.Character#toUpperCase
    * @see    java.lang.StringBuffer
    * @see    java.lang.String#charAt
    * @see    java.lang.String#valueOf
    */
    public static final String capitalize (String word) {
        if (word.length() == 1) {
            return  ( String.valueOf(Character.toUpperCase(word.charAt(0))) );
        } else {
            return ( String.valueOf(Character.toUpperCase(word.charAt(0)))
                     + word.substring(1) );
        }
    }

   /**
    * Constructs a new string identical to its argument, but with all
    * characters replaced by their upper case equivalents.
    *
    * @param    word      String to be uppercased.
    *
    * @return  the new, uppercased String.
    *
    * @see    java.lang.Character#toUpperCase
    * @see    java.lang.String#length
    * @see    java.lang.String#charAt
    * @see    java.lang.StringBuffer
    */
    public static final String capitalizeAll (String word) {
        StringBuffer tmp = new StringBuffer (word.length());

        for (int i = 0; i < word.length(); i++) {
            tmp.insert (i, Character.toUpperCase(word.charAt (i)));
        }
        return tmp.toString();
    }

   /**
    * Constructs a new string identical to its argument, but with the
    * first character replaced by its lower case equivalent.
    *
    * @param    word      String to be unCapitalized.
    *
    * @return  the new, unCapitalized String.
    *
    * @see    java.lang.Character#toLowerCase
    * @see    java.lang.String#length
    * @see    java.lang.String#charAt
    * @see    java.lang.String#valueOf
    */
    public static final String unCapitalize (String word) {
        if (word.length() == 1) {
            return  ( String.valueOf(Character.toLowerCase(word.charAt(0))) );
        } else {
            return ( String.valueOf(Character.toLowerCase(word.charAt(0)))
                     + word.substring(1) );
        }
    }

   /**
    * Computes the index of the first position in String which
    * contains a vowel (i.e., one of AEIOU).
    *
    * @param    word      String to be searched for vowel.
    *
    * @return  index of first vowel, length of word if no vowel.
    *
    * @see    java.lang.String#length
    * @see    java.lang.String#charAt
    */
    public static final int firstVowelPos ( String word ) {
        int i = 0, length = word.length();

      LETTER:
        for(i = 0; i < length; i++) {
            switch(word.charAt(i)) {
                case 'a':   case 'A':
                case 'e':   case 'E':
                case 'i':   case 'I':
                case 'o':   case 'O':
                case 'u':   case 'U': break LETTER;
                default:
            }
        }
        if (i == length) {
            return 0;
        } else {
            return i;
        }

    }

}

/* Comments:
 *
 * History:
 *     $Log: StringUtils.java,v $
 *     Revision 1.1  1998/03/13 22:18:23  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.4  1996/08/01 18:26:33  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.3  1996/08/01 16:23:30  reuben
 *     Fixed javadoc problem.
 *
 *     Revision 1.2  1996/07/30 17:26:01  reuben
 *     Added/corrected javadoc comments.
 *
 *     Revision 1.1.1.1  1996/07/18 17:38:24  sit
 *     Import from /mit/6.096/share/classes after 6.80s session
 *
 *     Revision 1.3  1996/06/19 23:04:57  las
 *     Cleanerer.
 *
 *     Revision 1.2  1996/06/19 22:48:05  las
 *     Cleaned up documentation.
 *
 *     6-19-96  Documentation cleaned up by las@ai.mit.edu 
 *     6-18-96  Created by las@ai.mit.edu 
 *
 *
 */





