/*
 * $Id: StringHandler.java,v 1.1 1998/03/13 22:18:22 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */
package cs101.util;

/**
 * An interface for objects that can handle Strings received from the network by
 * cs101.util.Client.
 *
 * @see cs101.util.Client
 *
 * @author Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: StringHandler.java,v 1.1 1998/03/13 22:18:22 tparnell Exp $
 */
public interface StringHandler {
    public void handleString( String s );
}

    
/*
 * $Log: StringHandler.java,v $
 * Revision 1.1  1998/03/13 22:18:22  tparnell
 * Import from server crash.  I think the src and class files match up.
 *
 * Revision 1.1  1996/11/18 17:25:06  las
 * Added revised SharedWhiteboard support classes.  These versions of
 * Client and Server supercede the previous ones and are not directly
 * backwards compatible.  In particular, Server is an instantiable class
 * rather than a primarily static one (use RunServer to run it), and
 * Client uses StringHandler rather than subclassing to specialize it.
 * Line.java just picked up some obscure documentation along the way.
 * Otherwise, classes are direct imports from SharedWhiteboard.
 *
 * Revision 1.2  1996/11/17 22:28:19  las
 * Everything compiles (now).  Client, Server, ClientDialog, ServerDialog,
 * StringHandler, and RunServer need to be moved to cs101.util.  But
 * first, to test....
 *
 */

