/* 
 * $Id: Main.java,v 1.2 1998/06/07 17:00:07 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

/**
 * Main hides the public static void main( String[] argv ) construct
 * from students by providing a command line interface.  Each command
 * line argument is treated as a class name that is instantiated once.
 *
 * @see cs101.util.Coerce
 *
 * @author  Todd C. Parnell, tparnell@ai.mit.edu
 * @version $Id: Main.java,v 1.2 1998/06/07 17:00:07 tparnell Exp $
 * <br>
 * Copyright 1998 Massachusetts Institute of Technology
 *
 */
public final class Main {

  public static void main(String[] argv) {
    for (int i = 0; i < argv.length; ++i) {
      try {
	Object o = Coerce.NewInstanceByClassname( argv[i] );
      } catch (CreationException ce) {
	System.err.println("Could not create " + argv[i]);
	System.err.println("Make sure you typed the class name correctly and that a no argument constructor exists.");
      }
    }
  }
}

/*
 * $Log: Main.java,v $
 * Revision 1.2  1998/06/07 17:00:07  tparnell
 * changed to use NewInstanceByClassname
 *
 * Revision 1.1  1998/06/04 23:18:14  tparnell
 * added a StringToObject method in Coerce, and a generic Main wrapper so
 * students can avoid public static void main(String[] argv)
 *
 */


