//GroupServerDemo.java

package cs101.util;
import java.io.*;

public class GroupServerDemo
{	
	public static void main(String args[]) {
		if (args.length>0 && args[0].equals("Server")) {
			GroupServer gs= new GroupServer();
		} else {
			GroupClientTester gct= new GroupClientTester();
		}
	}
}

/*
 * cs101 Client Tester
 * $Id: GroupServerDemo.java,v 1.1 1998/06/24 16:32:19 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */


/**
 * cs101.util.ClientTester is a simple driver for the Client class.
 * It reads lines from System.in, then echoes to System.out and a Client.
 *
 * @see Client
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: GroupServerDemo.java,v 1.1 1998/06/24 16:32:19 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Techonology
 *
 */
class GroupClientTester implements Runnable, GroupWatcher {
	Wire gcw;
	Thread sender;
	boolean running= true;
	
	public void run() {
		BufferedReader in =new BufferedReader(new InputStreamReader(System.in));
		try {
			while (true) {
				gcw.writeObject(in.readLine());
			}
		} catch (IOException e) {
			running= false;
		}
	}
	
	public void userJoined(String id) {
		System.out.println("User "+id+" joined");
	}
	
	public void userLeft(String id) {
		System.out.println("User "+id+" left");
	}
	
	public GroupClientTester() {
		gcw = new GroupClientWire();
		sender= new Thread(this);
		sender.start();
//		try {
			while (running) {
				System.out.println((String)(gcw.readObject()));
			}
//		} catch (IOException  e) {}
		System.out.println ("Shutting down.");
	}
}
