/*
 * cs101.util.GroupClient.java
 * $Id: GroupClient.java,v 1.3 1998/06/24 21:36:56 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.net.*;
import java.awt.*;
import java.util.*;
import java.io.*;

/** A client that connects to one of many groups on a central server.
 * This client only knows how to send strings.
 * 
 * @see GroupServer
 * @see Client
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Mike Wessler, wessler@ai.mit.edu
 *
 * Copyright (c) 1998 Massachusetts Institute of Technology
 */
public class GroupClient extends Client implements GroupWatcher
{
  /** 
   * The group dialog box.  If this variable is null, we're in
   * client mode.  If this variable is not null, then we're in
   * selection mode.
   */
  GroupDialog gd = null;
  String userID  = null;

  public void userJoined(String userID) {
    System.out.println("User " + userID + " joined");
  }
	
  public void userLeft(String userID) {
    System.out.println("User " + userID + " left");
  }

  /**
   * read strings from the server.  These strings will either be *
   * processed in this method (if we're in selection mode) or they *
   * will be passed off to the stringHandler.
   * 
   * @see Client#stringHandler
   * @see StringHandler#handleString(String) 
   */
  public void run() {
    System.out.println( "Client:  starting read loop." );
    String s;
    this.gd = new GroupDialog(this);
    this.gd.show();
    send(GroupServer.GET_GROUPS);
    try {
      while (true) {
	s = this.is.readUTF();
	if (this.gd != null) {
	  if (s.startsWith(GroupServer.JOINED)) {
	    this.userID = s.substring(GroupServer.JOINED.length());
	    System.out.println("UserID is " + this.userID);
	    this.gd.dispose();
	    this.gd = null;
	  } else if (s.equals(GroupServer.GROUPS_CHANGED)) {
	    send(GroupServer.GET_GROUPS);
	  } else if (s.startsWith(GroupServer.GROUP_LIST)) {
	    gd.parseGroups(s);
	  } else {
	    System.out.println("Received unknown: '" + s + "'");
	  }
	} else if (s.equals(GroupServer.SELECT_GROUP)) {
	  this.gd = new GroupDialog(this);
	  this.gd.show();
	  send(GroupServer.GET_GROUPS);
	} else if (s.startsWith(GroupServer.JOINED)) {
	  this.userJoined(s.substring(GroupServer.JOINED.length()));
	} else if (s.startsWith(GroupServer.CLIENT_LEFT)) {
	  this.userLeft(s.substring(GroupServer.CLIENT_LEFT.length()));
	} else {
	  this.stringHandler.handleString(s);
	}
      }
    } catch (IOException e) {
      throw new RuntimeException("Client:  failed to read");
    }
  }

}

/*
 * $Log: GroupClient.java,v $
 * Revision 1.3  1998/06/24 21:36:56  tparnell
 * added logging
 *
 */









