/*
 * cs101 DisplayField utility 
 * $Id: DisplayField.java,v 1.2 1998/06/03 19:32:20 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.awt.*;

/**
 * cs101.util.DisplayField extends cs101.util.ColorField to add a line of
 * text to the colored rectangle.<p>  The size of the rectangle is supposed
 * to change with the length of the text.  The color of the field can also
 * change btwn two predetermined colors.  
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Joshua R. Brown, reuben@ai.mit.edu
 * @version $Id: DisplayField.java,v 1.2 1998/06/03 19:32:20 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public class DisplayField extends ColorField {

  /** the string to be displayed */
  protected String text;   
  
  // DisplayField(String, boolean, Dimension, Color, Color)
  /**
   * Constructs a rectangular colorfield with the passed
   * attributes.
   *
   * @param text       The text to intially display in the field.
   * @param initState  The initial state of the color field.
   * @param trueColor  The color of the field when the state is true.
   * @param falseColor The color of the field when the state is false.  
   */
  public DisplayField(String text, boolean initState, Color trueColor,
		      Color falseColor) {
    super(initState, new Dimension(25,25), trueColor, falseColor);
    this.text = text;
  }

  // setText(String)
  /**
   * Changes the text of the DisplayField to the string passed.
   *
   * Should also resize the component to fit the text.
   * This is not fully implemented yet.
   *
   * @param text  The string to be displayed in the field.
   */
  public void setText(String text) {
    this.text = text;
    measure();
    repaint();
  }

  /**
   * This method is called to determine the size of the
   * rectangle given the current text to display.
   */
  private void measure() {
    Dimension oldSize = new Dimension(this.dim);

    FontMetrics fm = this.getFontMetrics(this.getFont());
    
    // If we don't have font metrics yet go with our guess
    if (fm == null)       
      return;        
    
    this.dim.height=fm.getHeight()+16;
    this.dim.width=fm.stringWidth(this.text)+20;

  }

  /**
   * Calls super.addNotify.  Then measures it's intial size.
   * <br> 
   * Note: Must be called from here so that the Font Metrics is available
   * for measuring.
   */
  public void addNotify() {
    super.addNotify();
    measure();
  }

  /**
   * Called by this object's container
   * to determine the minimum space required by this object. 
   *
   * @return the prefered size of the object
   */	
  public Dimension getPreferredSize() { return this.dim; }

  /**
   * Called by this object's container
   * to determine the minimum space required by this object. 
   *
   * @return the minimum size of the object
   */
  public Dimension getMinimumSize() { return this.dim; }
 
  /**
   * Calls the ColorField.paint to do the field.
   * Then adds the text in black.
   *
   * @param g The graphics context to paint into.
   */
  public void paint(Graphics g) {
    super.paint(g);

    // draw the text
    g.setColor(Color.black);
    g.drawString(this.text,10,this.dim.height-10);
    
  }

}


/* Comments:
 *
 * History:
 *     $Log: DisplayField.java,v $
 *     Revision 1.2  1998/06/03 19:32:20  tparnell
 *     update from Java 1.0 to 1.1
 *
 *     Revision 1.1  1998/03/13 22:18:12  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.4  1996/08/01 18:26:20  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.3  1996/08/01 16:19:55  reuben
 *     Fixed javadoc problem with return.
 *
 *     Revision 1.2  1996/07/25 18:27:41  reuben
 *     Added all kinds of comments.
 *     Compiled and tested.
 *
 */
