/*
 * $Id: DefaultStringHandler.java,v 1.1 1998/03/13 22:18:12 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */
package cs101.util;

/**
 * A default StringHandler.  Just prints things to System.out.
 *
 * @see cs101.util.Client
 * @see cs101.util.StringHandler
 *
 * @author Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: DefaultStringHandler.java,v 1.1 1998/03/13 22:18:12 tparnell Exp $
 */

public class DefaultStringHandler implements StringHandler {

    public DefaultStringHandler ()  {
	super();
    }

    /**
     * Just print the string to System.out.
     */
    public void handleString( String s ) {
	System.out.println("<stringhandler got \""+ s + "\" >");
	System.out.flush();
    }

}

/*
 * $Log: DefaultStringHandler.java,v $
 * Revision 1.1  1998/03/13 22:18:12  tparnell
 * Import from server crash.  I think the src and class files match up.
 *
 */
