/*
 * $Id: DefaultReadLoop.java,v 1.3 1998/06/03 21:56:46 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */
package cs101.util;

import java.io.*;

/**
 * A generic read loop for a client.
 *
 * @see cs101.util.Client
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: DefaultReadLoop.java,v 1.3 1998/06/03 21:56:46 tparnell Exp $
 */
public class DefaultReadLoop implements Runnable {

    /** Communicates with the network. */
    protected Client client;
    /** Animates this object.*/
    protected Thread spirit;


    /**
     * A generic read loop for client.
     *
     * @see Client
     */
    public DefaultReadLoop ( Client c ) {
	this.client = c;
	this.spirit = new Thread (this);
	this.spirit.start();
    }

    /**
     * Called by this object's thread.  Shouldn't be called otherwise.
     */
    public void run () {
      BufferedReader in = 
	new BufferedReader(new InputStreamReader(System.in));
	while (true) {
	    System.out.println(">>");
	    System.out.flush();
	    try {
		this.client.send( in.readLine() );
	    } catch (IOException e) {}
	}
    }
}

/*
 * $Log: DefaultReadLoop.java,v $
 * Revision 1.3  1998/06/03 21:56:46  tparnell
 * minor bugfix
 *
 * Revision 1.2  1998/06/03 19:28:16  tparnell
 * update from Java 1.0 to 1.1.
 *
 * Revision 1.1  1998/03/13 22:18:11  tparnell
 * Import from server crash.  I think the src and class files match up.
 *
 */


