/*
 * cs101 DefaultFrame
 * $Id: DefaultFrame.java,v 1.3 1998/06/03 19:05:01 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.awt.*;
import java.awt.event.*;

/** 
 * Simple toplevel that deals with one component and sizing.
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author <nathanw@mit.edu>
 * @version $Id: DefaultFrame.java,v 1.3 1998/06/03 19:05:01 tparnell Exp $
 */
public class DefaultFrame extends Frame {
  protected Component c;
  
  /** 
   * Initilize the frame and set up a listener for windowClosing events.
   * Does not show the frame.  To show the frame, use init().
   *
   * @see #init
   *
   * @param	c	Component to display.
   */
  public DefaultFrame(Component c) {
    super("Default");
    this.c=c;

    this.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        DefaultFrame.this.dispose();
        System.exit(0);
      }
    });
  }

  /**
   * Make the frame appear 
   */
  public void init() {
    this.add("Center",c);
    this.pack();
    this.show();
  }
}

/*
 * $Log: DefaultFrame.java,v $
 * Revision 1.3  1998/06/03 19:05:01  tparnell
 * added log to bottom of file
 *
 */      

    
    
  
