
/*
 * $Id: Console.java,v 1.1 1998/06/08 18:11:52 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */
package cs101.util;
import java.io.*;

/**
 * A helper class for Java Console IO.  Contains appropriate console Reader   
 * and Writer objects as static fields.
 *
 * Exists mostly to make System.In palatable by transforming it into a 
 * readLine-able BufferedReader.  Out and Err are included for completeness
 * and uniformity.<p>
 *
 * @see      System
 *
 * @author   Lynn Andrea Stein, las@ai.mit.edu
 * @version  $Id: Console.java,v 1.1 1998/06/08 18:11:52 tparnell Exp $
 * <br>
 * Copyright 1998 Massachusetts Institute of Technology
 *
 */

public class Console {

    /** A console Reader; e.g., allows you to readLine() from the console. */
    public
    static
    final
    FriendlyReader in = new FriendlyReader(new InputStreamReader(System.in));
	
    /** A console Writer; e.g., allows you to println() to the console */
    public static final PrintWriter out = new PrintWriter ( System.out , true);
	
    /** The special console Writer for error messages. */
    public static final PrintWriter err = new PrintWriter( System.err , true);
	
}

/* Comments:
 *
 * History:
 *     $Log: Console.java,v $
 *     Revision 1.1  1998/06/08 18:11:52  tparnell
 *     added files from Lynn
 *
 */
 
