/*
 * cs101 boolean semaphore utility
 * $Id: BS.java,v 1.2 1998/06/24 20:59:27 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

/**
 * cs101.util.BS implements simple binary semaphores in java.<br>
 * Interface is bs.request(), bs.release().
 *
 * @author  Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: BS.java,v 1.2 1998/06/24 20:59:27 tparnell Exp $ 
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public class BS {
  private boolean busy;

  //  BS( boolean )
  /**
   * If the constructor is passed a boolean value, the semaphore will
   * be initialized with this value (true => in use, false => free).
   *
   * @param    initVal   Initial value for semaphore.  (true => in use)
   */
  public BS (boolean initVal) {
    this.busy = initVal;
  }


  // BS()
  /**
   * If no argument is supplied, the semaphore is created in its free
   * state. 
   */
  public BS () {
    this(false);
  }

  // request()
  /**
   * Requests the semaphore.  If the semaphore is currently busy,
   * causes the requesting process to wait() until the semaphore is
   * release()d.  Unlike java.lang.Object.wait(), the requesting
   * process is not suspended if the semaphore is currently free.
   *
   * @see #release
   * @see java.lang.Object#wait
   */
  synchronized public void request () {
    while (this.busy) {
      try {this.wait();} catch (InterruptedException e) {}
    }
    this.busy = true;
  }

  // release()
  /**
   * Releases the semaphore.  Any objects currently wait()ing on the
   * semaphore are notify()d (and one of them will be granted the
   * semaphore).  Unlike java.lang.Object.notify(), the semaphore is
   * also freed so that if there are no wait()ing objects, the next
   * object to request() the semaphore will receive it.
   *
   * @see #request
   * @see java.lang.Object#notifyAll()
   */
  synchronized public void release () {
    this.busy = false;
    this.notifyAll();
  }
}


/* Comments:
 *
 * History:
 *     $Log: BS.java,v $
 *     Revision 1.2  1998/06/24 20:59:27  tparnell
 *     formatting
 *
 *     Revision 1.1  1998/03/13 22:18:02  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.5  1996/08/01 18:26:15  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.4  1996/07/30 17:25:59  reuben
 *     Added/corrected javadoc comments.
 *
 *     Revision 1.3  1996/07/25 18:27:41  reuben
 *     Added all kinds of comments.
 *     Compiled and tested.
 *
 *     Revision 1.2  1996/07/25 15:21:51  reuben
 *     test
 *
 *     Revision 1.1.1.1  1996/07/18 17:38:24  sit
 *     Import from /mit/6.096/share/classes after 6.80s session
 *
 *     Revision 1.2  1996/06/19 22:48:05  las
 *     Cleaned up documentation.
 *
 *     Revision 1.1  1996/06/19 16:47:43  las
 *     Initial revision
 *     6-19-96  Documentation cleaned up by las@ai.mit.edu 
 *     6-18-96  Created by las@ai.mit.edu 
 *
 */

