/*
 * $Id: AnimateObject.java,v 1.2 1998/06/24 20:58:36 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */
package cs101.util;

/**
 * The generic self-animating (active) object.  
 *
 * Override act() to create an animate object in the event-driven style.<p>
 *
 * @see      Thread
 * @see      Runnable
 *
 * @author   Lynn Andrea Stein, las@ai.mit.edu
 * @version  $Id: AnimateObject.java,v 1.2 1998/06/24 20:58:36 tparnell Exp $
 * <br>
 * Copyright 1998 Massachusetts Institute of Technology
 *
 */
public class AnimateObject implements Runnable {

  /**
   * The animacy that makes this object go.
   */
  private Thread spirit;
	
  /**
   * Constructor starts the animacy going.
   */
  public AnimateObject() {
    this.spirit = new Thread(this);
    this.spirit.start();
  }

  /**
   * Repeatedly do what you're supposed to.
   */
  public void run() {
    while ( true ) {
      this.act();
    }
  }
	
  /**
   * Override this method to give the AnimateObject behavior.
   *
   * The default behavior -- Thread.yield() -- simply gives other 
   * animacies a chance to run.
   */
  public void act() {	
    Thread.yield();
  }

}


/* Comments:
 *
 * History:
 *     $Log: AnimateObject.java,v $
 *     Revision 1.2  1998/06/24 20:58:36  tparnell
 *     formatting fixed
 *
 *     Revision 1.1  1998/06/08 18:11:52  tparnell
 *     added files from Lynn
 *
 */
 
