package Scribble;

import java.awt.*;
import java.util.*;
import cs101.util.*;

public class ScribbleData {

    private Component gui;

    private Vector lines = new Vector();

    public ScribbleData() {
    }
			  
    public ScribbleData(Component gui) {
	this.gui = gui;
    }

    public void setGUI(Component gui) {
	this.gui = gui;
    }

    protected void paintLines (Graphics g) {
	for (int i = 0; i < lines.size(); i++) {
	    ((Line)lines.elementAt(i)).drawOn(g);
	}
    }

    public synchronized void addLine (Line newLine) {
	lines.addElement(newLine);
	if (this.gui != null) {
	    newLine.drawOn(this.gui.getGraphics());
	}
    }

    public synchronized void clearLines() {
	lines.removeAllElements();
	gui.repaint();
    }
}





