/*
 * ScribbleCanvas class 
 * $Id: ScribbleCanvas.java,v 1.3 1998/06/04 19:01:11 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package Scribble;

import java.awt.*;
import java.awt.event.*;
import cs101.util.Line;

/**
 * An extended SmartCanvas that echos user's mouse strokes as lines.<p>
 *
 * Handles mouse events (by creating lines to put in the repository),
 * can be given a Color in which to draw, can be cleared.<p>
 *
 * @see      SmartCanvas
 *
 * @author   Todd C. Parnell, tparnell@ai.mit.edu
 * @author   Maciej Stachowiak, maciej@ai.mit.edu
 * @author   Lynn Andrea Stein, las@ai.mit.edu
 * @version  $Id: ScribbleCanvas.java,v 1.3 1998/06/04 19:01:11 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public class ScribbleCanvas extends SmartCanvas {

  // Some integers to store a point in
  protected int currX, currY;

  // the current color to draw lines in
  protected Color currColor;


  public ScribbleCanvas(ScribbleData sd) {
    super(sd);
    this.init();
  }
  /**
   * Creates a new canvas.
   */
  public ScribbleCanvas() {
    super();
    this.init();
  }

  private void init() {
    this.addMouseListener(new MouseListener() {
      public void mouseClicked(MouseEvent e) {}
      public void mouseEntered(MouseEvent e) {}
      public void mouseExited(MouseEvent e) {}
      public void mousePressed(MouseEvent e) {
	setCoords(e.getX(), e.getY());
      }
      public void mouseReleased(MouseEvent e) {
	lineTo(e.getX(), e.getY());
	resetCoords();
      }
    });

    this.addMouseMotionListener(new MouseMotionListener() {
      public void mouseDragged(MouseEvent e) {
	lineTo(e.getX(), e.getY());
	setCoords(e.getX(), e.getY());
      }
      public void mouseMoved(MouseEvent e) {}
    });

    this.resetCoords();
  }

  
  
  /** 
   * Removes all lines from the data repository.
   *
   * Then forces a call to the paint method.
   */
  public void clearLines() {
    this.repository.clearLines();
    this.repaint();
  }

  /** 
   * Changes the drawing color.
   * @param c the new drawing color.
   */
  public void setColor ( Color c ) {
    this.currColor = c;
  }

  /**
   * Gives the x and y coords impossible values to signal 
   * that new coords are expected.
   */
  protected void resetCoords() {
    this.currX = -1;
    this.currY = -1;
  }

  /**
   * Saves the starting point for drawing a line in currX, currY
   * @param x the x coord of the starting point
   * @param y the y coord of the starting point
   */
  protected void setCoords( int x, int y ) {
    this.currX = x;
    this.currY = y;
  }

  /**
   * Adds a line (from the saved start point to the point passed)
   * to the data repository.
   * @param endX the x coord of the line's endpoint
   * @param endY the y coord of the line's endpoint
   */
  protected void lineTo( int endX, int endY) {
    this.repository.addLine(new Line(this.currX, this.currY, 
				     endX, endY, this.currColor));
  }
}


/* Comments:
 *
 * History:
 *     $Log: ScribbleCanvas.java,v $
 *     Revision 1.3  1998/06/04 19:01:11  tparnell
 *     minor mods
 *
 *     Revision 1.2  1998/06/04 16:59:57  tparnell
 *     old version was incomplete.  this version is an import from fall96
 *     with updates to Java 1.1 and corrrections to work with new files
 *
 *     Revision 1.6  1996/10/28 18:06:47  nathanw
 *     Revert the change of putting them in a Scribble package.
 *
 *     Revision 1.5  1996/10/26 21:04:17  nathanw
 *     Put all this stuff into a Scribble package
 *
 *     Revision 1.4  1996/10/24 22:43:05  las
 *     Changed everything.  Well, almost:
 *
 *     Both DumbDemo.java and WhiteboardDemo.java are standalone
 *     applications.  DumbDemo pops up the window w/all the appropriate
 *     widgets, but nothing much happens.   WhiteboardDemo is the fully
 *     functioning solution version.
 *
 *     Things have been broken up into what they write and what we give
 *     them.  They get ScribbleData, SmartCanvas, and Whiteboard.  They write
 *     DumbDemo and ScribbleCanvas, and (if they're ambitious) maybe
 *     WhiteboardSoln/Demo.  They could even extend WhiteboardSoln further,
 *     putting in extra components, but then they'd have to significantly
 *     extend or at least override Whiteboard as well.
 *
 *     ScribbleData remained roughly the same.
 *     ScribbleCanvas got broken into SmartCanvas (handles the repository &
 *        painting) and ScribbleCanvas (handles the mouse events & optionally
 *        the clear/color methods).
 *     Whiteboard got broken into Whiteboard (sets up the widgets, doesn't do
 *        anything with them and WhiteboardSoln (handles the action events).
 *        Also, the Applet's init was retained, since it does the Right Thing.
 *        There is some hair in (1) how constructor arguments are handled and
 *        (2) the (non-)overriding of drawingArea, but all appears to work
 *        smoothly.  I don't expect students to come up with this particular
 *        solution.
 *     WhiteboardDemo and DumbDemo got added, as they turn things into a
 *     standalone.
 *
 *     Revision 1.3  1996/08/04 05:37:26  reuben
 *     Changed setColor and setData methods to be protected.
 *     This allows access from non-subclass objects in the same package.
 *
 *     Revision 1.2  1996/08/03 23:06:16  reuben
 *     Tweaked comments.
 *
 *     Revision 1.1.1.1  1996/07/23 17:21:27  sit
 *     Import from summer 6.80s web tree
 *
 *     Revision 1.1  1996/07/05 15:15:26  las
 *     Initial revision
 *
 *
 */

