package CatAndMouse;

public class ServerDialog {
  
    private QueryDialog qd;
    private String[] answers, questions;
    /**
     * Creates the dialog information.
     * To show the dialog, call ask().
     * To retrieve information, use int getPort().
     */
     public ServerDialog() {
	 this.questions = new String[1];
	 this.questions[0] = "Port";
	 this.answers = new String[1];
	 this.answers[0] = "4321";
	 this.qd = new QueryDialog("Please enter the port to listen on.",
				   this.questions,
				   this.answers);
    }

    /**
     * Actually display the query dialog and get the answers from the user.
     *
     * @see getPort()
     */ 
    public synchronized void ask() {
	this.answers = this.qd.ask();
    }

    /**
     * Return the port number from the user.  Not guaranteed to be sensible
     * if ask hasn't aready been called.
     *
     * @see ask()
     */
    public synchronized int getPort() {
	try {
	    return Integer.parseInt( this.answers[0] );
	} catch ( NumberFormatException e ) {
	    throw new RuntimeException("Bad port number '"+answers[0]+"'");
	}
    }

}
    
    
/*
 * $Log: ServerDialog.java,v $
 * Revision 1.1  1998/02/26 17:36:23  tparnell
 * Recreate from server crash.  Everything appears intact.
 *
 * Revision 1.1  1997/07/29 13:37:48  henryw
 * These files were modified by Henry Wong (henryw@mit.edu) to use
 * Java 1.1 The wire now supports Object Serialization, and the demo has
 * been cleaned up a little bit.
 *
 * Revision 1.1  1996/11/18 17:25:06  las
 * Added revised SharedWhiteboard support classes.  These versions of
 * Client and Server supercede the previous ones and are not directly
 * backwards compatible.  In particular, Server is an instantiable class
 * rather than a primarily static one (use RunServer to run it), and
 * Client uses StringHandler rather than subclassing to specialize it.
 * Line.java just picked up some obscure documentation along the way.
 * Otherwise, classes are direct imports from SharedWhiteboard.
 *
 * Revision 1.4  1996/11/17 22:28:17  las
 * Everything compiles (now).  Client, Server, ClientDialog, ServerDialog,
 * StringHandler, and RunServer need to be moved to cs101.util.  But
 * first, to test....
 *
 * Revision 1.3  1996/11/17 21:26:54  las
 * Client, ClientDialog writen, not yet tested.
 *
 */

