package CatAndMouse;

public class Queue {
  private Link first = null;
  private Link last = null;

  public Queue () {}

  public Queue (Object obj) {
    this.first = this.last = new Link (obj);
  }

  public synchronized Object head () {
    return this.first.contents();
  }

  public synchronized void enQueue ( Object obj ) {
    if ( this.last == null ) {
      this.first = this.last = new Link( obj );
    } else {
      this.last.setNext( new Link( obj ) );
      this.last = this.last.next();
    }
  }

  public synchronized Object deQueue () {
    Object tmp = this.first.contents();
    this.first = this.first.next();
    if ( this.first == null ) {
      this.last = null;
    }
    return tmp;
  }

  public synchronized boolean isEmpty () {
    return (this.first == null);
  }

}



class Link {

  private Link next = null;
  private Object contents;

  protected Link( Object obj ) {
    this.contents = obj;
  }

  public Object contents() {
    return this.contents;
  }

  public Link next() {
    return this.next;
  }

  protected synchronized void setNext( Link link ) {
    this.next = link;
  }


}





