package CatAndMouse;

import java.awt.*;
import java.awt.event.*;


/** A class to display a toplevel dialog box with a message, 
    a list of "things" and associated textfields, and get answers.
    @author <nathanw@mit.edu>
    @version $Id: QueryDialog.java,v 1.1 1998/02/26 17:36:18 tparnell Exp $
*/
public class QueryDialog extends Frame {
  
  private String message;
  private String[] fields,values;
  private TextComponent[] entries;
  private Button ok;
  
  
  /** Create a hidden QueryDialog with the appropriate text and defaults. */
  public QueryDialog(String message, String[] fields, String[] values) {

    this.message=message;
    this.fields=fields;
    this.values=values;

  }
  
  /** Display the dialog box, and block until the OK button is checked. */

  public synchronized String[] ask() {

    Label l;
    int i;

    this.removeAll();

    GridBagLayout gridbag = new GridBagLayout();
    this.setLayout(gridbag); 

    GridBagConstraints gbc,gblabel,gbarea;

    gbc = new GridBagConstraints();
    gblabel = new GridBagConstraints();
    gbarea = new GridBagConstraints();

    
    gbc.gridwidth=1;
    gbc.gridheight=1;
    gbc.fill=GridBagConstraints.BOTH;
    gbc.weightx=1;
    gbc.weighty=1;

    gblabel=(GridBagConstraints) gbc.clone();
    gbarea=(GridBagConstraints) gbc.clone();

    gbarea.gridwidth=GridBagConstraints.REMAINDER;
    gblabel.gridwidth=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    String[] lines = getLines(message);
    for(i=0;i<lines.length;i++) {
      l = new Label(lines[i]);
      gridbag.setConstraints(l,gbc);
      add(l);
    }
      

    
    gbarea.gridwidth=GridBagConstraints.REMAINDER;

    entries = new TextComponent[fields.length];

    for(i=0;i<fields.length;i++) {
     l = new Label(fields[i]);
     gridbag.setConstraints(l,gblabel);
     add(l);

     entries[i] = new TextField(values[i],40);
     entries[i].setEditable(true);
     gridbag.setConstraints(entries[i],gbarea);
     add(entries[i]);
    }

    gbc.gridheight=1;

  /** Close the window when OK is checked. */
    
    ok = new Button("OK");
    gridbag.setConstraints(ok,gbc);

    ok.addActionListener(new ActionListener() {
	public void actionPerformed(ActionEvent e) {    
	    dispose();
	    synchronized (QueryDialog.this) {
		QueryDialog.this.notifyAll();
	    }
	}
    });

    add(ok);


    this.pack();
    this.show();
    try {
	this.wait();
    } catch (InterruptedException e) {
    }
    return this.getValues();
  }      

  private String[] getLines(String s) {
    int i,pos,prev;
    int lines=countLines(s);
    String[] ss=new String[lines];

    i=0;
    prev=0;
    pos=s.indexOf('\n');
    while(pos!=-1) {
      ss[i]=s.substring(prev,pos);
      prev=pos+1; // First character after the newline
      pos=s.indexOf('\n',prev);
      i++;
    }

    ss[i]=s.substring(prev);

    return ss;
  }

  /** Count lines in a string */
  private int countLines(String s) {
    char[] c = new char[s.length()];
    int i,lines=1;
    
    s.getChars(0,s.length()-1,c,0);
    for(i=0;i<c.length;i++) 
      if(c[i]=='\n') 
	lines++;


    return lines;
  }
      
  /** Create a hidden QueryDialog with the appropriate text. */
  public QueryDialog(String message, String[] fields) {
    this(message,fields,new String[fields.length]);
  }

  public void setValues(String[] newfields) {
    int i,max;

    if(fields.length < newfields.length) 
      max=fields.length;
    else
      max=newfields.length;
    
    for(i=0;i<max;i++) {
      fields[i]=newfields[i];
    }      
  
  }

  /** Return the last entered values for the field. */
  public String[] getValues() {
    String[] data=new String[entries.length];
    int i;

    for(i=0;i<entries.length;i++)
      data[i]=entries[i].getText();

    return data;
  }

}
    
