package CatAndMouse;

import java.awt.*;
import cs101.util.*;

public class MouseThread implements Runnable {
	// This class starts a Thread and keeps checking for the
	// Cat to send hit/miss packets. It then reads each packet
	// and displays the appropriate message.

    private Thread spirit;
	private Wire myWire;
    private MousePanel myPanel;
    
    public MouseThread (MousePanel myPanel, Wire myWire) {
		this.myPanel = myPanel;
		this.myWire = myWire;
		this.spirit = new Thread(this);
		this.spirit.start();
    }

    public void run () {
		while (true) {
			try {
				Packet catLoc = (Packet)myWire.readObject();
				if (catLoc.getType() == Packet.CAT_HIT) {
					System.out.println ("Hit at x: "+catLoc.getX()+
						" y: "+catLoc.getY());
				} else if (catLoc.getType() == Packet.CAT_MISS) {
					System.out.println ("Miss at x: "+catLoc.getX()
						+" y: "+catLoc.getY());
				} else {
					myPanel.setCatCoords(catLoc.getX(), catLoc.getY());
				}
			} catch (Exception e) {
				System.out.println ("Connection lost");
				System.exit(0);
			}
			myPanel.repaint();
			Thread.yield();
		}
    }
}
