package CatAndMouse;

import java.io.*;
import java.net.*;
import cs101.util.Wire;

public class Client implements Wire {

    private Socket mySocket;
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private ObjectOutputStream myOOS;
    private ObjectInputStream myOIS;

    private int portNumb;
    private String hostName;

    public Client() {
	ClientDialog cd = new ClientDialog();

	System.out.println ("Popping up ClientDialog");
	cd.ask();
	portNumb = cd.getPort();
	hostName = cd.getHostName();

	System.out.println ("Trying to create socket");
	try {
	    mySocket = new Socket(hostName, portNumb);
	} catch (IOException e) {
	    System.out.println ("Error creating socket");
	    System.exit(0);
	}

	System.out.println ("Trying to create inputStream");
	try {
	    myInputStream = mySocket.getInputStream();
	} catch (IOException e) {
	    System.out.println ("IO Exception creating InputSteam");
	    System.exit(0);
	}

	System.out.println ("Trying to create outputStream.");
	try {
	    myOutputStream = mySocket.getOutputStream();
	} catch (IOException e) {
	    System.out.println ("IO Exception creating OutputStream.");
	    System.exit(0);
	}

	System.out.println ("Trying to create ObjectOutputStream.");
	try {
	    myOOS = new ObjectOutputStream(myOutputStream);
	    myOOS.flush();
	} catch (IOException e) {
	    System.out.println ("Error creating ObjectOutpuStream");
	    System.exit(0);
	}

	System.out.println ("Trying to create ObjectInputStream.");
	try {
	    myOIS = new ObjectInputStream(myInputStream);
	} catch (IOException e) {
	    System.out.println ("Error creating ObjectInputStream");
	    System.exit(0);
	}

	System.out.println ("Done.");
    }

    public void writeObject (Object obj) {
	try {
	    myOOS.writeObject(obj);
	} catch (InvalidClassException e) {
	    System.out.println ("Something is wrong w/ the class you sent.");
	} catch (NotSerializableException e) {
	    System.out.println ("Object doesn't implement Serializable");
	} catch (IOException e) {
	    System.out.println ("IO Exception thrown");
	}
    }

    public Object readObject() {
	Object obj = null;
	
	try {
	    obj = myOIS.readObject();
	} catch (ClassNotFoundException e) {
	    System.out.println ("Couldn't find class of Object");
	} catch (InvalidClassException e) {
	    System.out.println ("Oops.");
	} catch (StreamCorruptedException e) {
	    System.out.println ("Uh oh.");
	} catch (OptionalDataException e) {
	    System.out.println ("Sending primitives again, huh Bob/");
	} catch (IOException e) {
	    System.out.println ("Error");
	}

	return obj;
	
    }
}



