package CatAndMouse;

import java.awt.*;
import cs101.util.*;

public class CatThread implements Runnable {
    private Thread spirit;
    private CatPanel myPanel;
    private Wire myWire;
    
    public CatThread (CatPanel myPanel, Wire myWire) {
		this.myWire = myWire;
		this.myPanel = myPanel;
		this.spirit = new Thread(this);
		this.spirit.start();
    }

    public void run (){
	/* This thread continually gets NetData from the other player
           concerning where his mouse is. It then calls the Panel's
           setMouseCoords method to change the Panel's Mouse coordinates
	   and tells the Panel to repaint. If this method blocks then the
           Thread pauses. However, this method will only block if the other
           mouse isn't moving, in which case the Thread doesn't need to
           do anything anyway. */

		while (true) {
			try {
				Packet mouseLoc = (Packet)myWire.readObject();
				myPanel.setMouseCoords(mouseLoc.getX(), mouseLoc.getY());
			} catch (Exception e) {
				System.out.println ("Connection lost");
				System.exit(0);
			}
			myPanel.repaint();
			Thread.yield();
		}
    }
}
