package CatAndMouse;

import java.awt.*;
import java.awt.event.*;
import cs101.util.*;

public class CatPanel extends Panel {
	
    /* This class handles GUI stuff. It has methods to handle moving and
       clicking the mouse, and also has accessor methods so that the Mouse's
       coordinates can be updated. */

    private int mouseX = 0;
    private int mouseY = 0;
	
	/* In order to draw the mouse on screen, the panel has to
           store the mouse's coordinates. */

    private int catX = 0;
    private int catY = 0;

	/* The panel also has to store the cat's coordinates. */

    private boolean Xin = false;
    private boolean Yin = false;
    
	/* If the coordinates had to be exactly equal to get a hit,
           it would be really hard for the cat to get a hit. I put
           in a tolerance, so I use these variables to tell whether
           or not the X and Y coordinates are close enough together. */

    private Wire myWire;

    public CatPanel (Wire theWire) {
		myWire = theWire;

	this.addMouseMotionListener(new MouseMotionListener() {
	    public void mouseMoved(MouseEvent e) {
		catX = e.getX();
		catY = e.getY();
		myWire.writeObject(new Packet (Packet.CATLOC,catX,catY));
		repaint();
	    }

	    public void mouseDragged(MouseEvent e){}
	    
	});
	
	this.addMouseListener(new MouseListener() {
	    public void mousePressed(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();

		boolean Xin =
		    ((mouseX - x <CatDemo.MOUSESIZE+CatDemo.CATSIZE)
		     && (x - mouseX<CatDemo.MOUSESIZE+CatDemo.CATSIZE));
		boolean Yin =
		    ((mouseY - y < CatDemo.MOUSESIZE + CatDemo.CATSIZE)
		     && (y - mouseY<CatDemo.MOUSESIZE+CatDemo.CATSIZE));
		
		if (Xin && Yin) {
		    
		    myWire.writeObject(new Packet (Packet.CAT_HIT,x,y));
		    
		    System.out.println ("A HIT occured at ("+x+","+y+")");
		    
		} else {
		    
		    myWire.writeObject(new Packet (Packet.CAT_MISS,x,y));
		    
		    System.out.println ("A MISS occured ar ("+x+","+y+")");
		}
	    }

	    public void mouseReleased(MouseEvent e) {}
	    public void mouseClicked(MouseEvent e) {}
	    public void mouseEntered(MouseEvent e) {}
	    public void mouseExited(MouseEvent e) {}
	    
	});
    }

    // The following 2 methods just help the GUI work correctly.
    
    public Dimension getMinimumSize() {
	return new Dimension (200, 200);
    }

    public Dimension getPreferredSize () {
	return new Dimension (400,400);
    }
    
    public synchronized void paint (Graphics g) {
	g.setColor (Color.red);
	g.fillOval (mouseX-CatDemo.MOUSESIZE/2,
		    mouseY-CatDemo.MOUSESIZE/2,
		    CatDemo.MOUSESIZE, CatDemo.MOUSESIZE);

	g.setColor (Color.black);
	g.fillOval (catX-CatDemo.CATSIZE/2, catY-CatDemo.CATSIZE,
		    CatDemo.CATSIZE, CatDemo.CATSIZE);
    }
	/* The cat's paint method paints a white circle to represent
           the Mouse and a black circle to represent the Cat. */	

    public synchronized void setMouseCoords (int x, int y) {
	/* This method is called by instances of other classes. */

	mouseX = x;
	mouseY = y;
    }
    
}
