/*
 * TerminatorNode.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.awt.*;

/**
 * This is the terminating Node for the BinSort Program. A terminating node will 
 * swallow any incoming objects and simply display how many it has swallowed.
 */
public class TerminatorNode extends Node {

    public TerminatorNode(SimulationPanel sp, ThreadGroup tg) {
	super(sp, tg, Color.black);
	my_behavior = new TerminatorNodeBehavior();
	setName("**UNNAMED Terminator**");
    }

    public void paint(Graphics g) {
	
	String num_des = Integer.toString(((TerminatorNodeBehavior)my_behavior).numDestroyed());

	g.setColor(Color.white);
	g.fillOval(this.pos.x - 10, this.pos.y - 10, 20, 20);
	g.setColor(Color.red);
	if (!isEnabled() && !forDisplayOnly) g.setColor(Color.gray);
	g.drawOval(this.pos.x - 10, this.pos.y - 10, 20, 20);
	g.setColor(Color.black);
	if (isSelected()) {
	    g.setColor(Color.red);
	    g.drawRect(this.pos.x - 10, this.pos.y - 10, 20, 20);
	}
	g.setColor(Color.black);
	g.drawString(num_des, this.pos.x + 15, this.pos.y + 5);
    }
}
    
