/*
 * Queue.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.util.Vector;

class Queue {

    private Vector rep;
	
    public Queue() { rep = new Vector(15); }
	
    public void addObject(Object o) { rep.addElement(o); }
	
    public Object getObject() throws EmptyQueueException {
	if (this.size() == 0) throw(new EmptyQueueException());
	Object ret = rep.elementAt(0);
	rep.removeElementAt(0);
	return(ret);
    }
	
    public Object peekObject() throws EmptyQueueException { 
	if (this.size() == 0) throw(new EmptyQueueException());
        return(rep.elementAt(0)); 
    }
	
    public void removeAll() { rep.removeAllElements(); }
	
    public int size() { return(rep.size()); }
}


