/*
 * Node.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.util.Vector;
import java.util.Enumeration;
import java.io.*;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Color;

/**
 * This class implements BinSortElement.  It is responsible for the
 * GUI and maintains its own thread.  It relies on a class that
 * implements NodeBehavior to do anything.  It repeatedly calls that
 * class's act method from within a while(true) {} loop.
 */
public class Node implements BinSortElement {

  protected int timeCounter = 0;
  final static int guiSize = 20;
  Color my_color;    
  Point pos;
  boolean selected, forDisplayOnly, enabled = true, destroyed;
  Thread spirit;
  ThreadGroup tg;
  String name;
  SimulationPanel my_sp;
  // For the Node Behavior
  NodeBehavior my_behavior;
    
  Vector inputChannels, outputChannels;
    
  public NodeBehavior getBehavior() { return my_behavior; }
    
  public void setPos(Point p) { this.pos = p; }
  public void setPos(int a, int b) { this.setPos(new Point(a, b)); }
  public Point getPos() { return(this.pos); }

  public void setSelected(boolean b) { selected = b; }
  public boolean isSelected() { return(selected); }

  public void setEnabled(boolean b) { 
    if (forDisplayOnly) return;
    enabled = b; 
  }
  public boolean isEnabled() { return enabled; }
    
  public void start() { 
    if (forDisplayOnly || !enabled) return;
    if (spirit == null) {
      spirit = new Thread(tg, this);
      spirit.start();
    }
    this.spirit.resume();
  }
  public void stop()  { 
    if (forDisplayOnly || !enabled || spirit == null) return;
    this.spirit.suspend();
  }
    
  public boolean isInside(Point p) { return(this.isInside(p.x, p.y)); }
  public boolean isInside(int x, int y) {
    if ((x > (pos.x - guiSize)) && (x < (pos.x + guiSize)) &&
	(y > (pos.y - guiSize)) && (y < (pos.y + guiSize))) {
      return(true);
    } else return(false);
  }
    
  public void setDisplayOnly() {  
    // Called when we want to draw a node, but not have it do anything.
    // Specifically, for the control panel.
    if (spirit != null) spirit.stop();
    spirit = null;
    forDisplayOnly = true;
    enabled = false;
    outputChannels.removeAllElements();
    inputChannels.removeAllElements();
  }

  public void destroy() {
    setEnabled(false); // stop the thread
    destroyed = true; //eliminate concurrency problems

    //tell channels we're going away
    Enumeration enum = inputChannels.elements();
    while (enum.hasMoreElements()) {
      ((Channel)enum.nextElement()).notifyOfDestruction((BinSortElement)this);
    }
    enum = outputChannels.elements();
    while (enum.hasMoreElements()) {
      ((Channel)enum.nextElement()).notifyOfDestruction((BinSortElement)this);
    }
      
    my_sp.notifyOfDestruction(this);
    setDisplayOnly();  // remove channels && cruft
  }
  public void notifyOfDestruction(BinSortElement bse) {
    if (destroyed) return;
    try {
      removeInputChannel( (InputChannel)bse );
      removeOutputChannel( (OutputChannel)bse );
    }
    catch (ClassCastException e) {}
  }
    
  public synchronized void addInputChannel(InputChannel c) {
    if (forDisplayOnly) return;
    inputChannels.addElement(c);
  }
  public synchronized void removeInputChannel(InputChannel c) {
    boolean b = inputChannels.removeElement(c);
  }
  public synchronized void addOutputChannel(OutputChannel c) {
    if (forDisplayOnly) return;
    outputChannels.addElement(c);
  }
  public synchronized void removeOutputChannel(OutputChannel c) {
    boolean b = outputChannels.removeElement(c);
  }
    
  public void setName(String n) { this.name = n; }
  public String getName() { return this.name; }
    
  public boolean isEditable() { return false; }
  public void configure() {}

  public Node(SimulationPanel sp, ThreadGroup ntg, Color c) {
    this.name = "*UNNAMED*";
    this.my_sp = sp;
    this.tg = ntg;
    inputChannels = new Vector();
    outputChannels = new Vector();
    my_behavior = new DefaultNodeBehavior();
    ///SP should override this...
    my_color = c;
  }
  public Node(NodeBehavior nb, SimulationPanel sp, ThreadGroup tg, Color c) {
    this(sp, tg, c);
    this.my_behavior = nb;
  }
    
  public void paint(Graphics g) {
    if (enabled || forDisplayOnly)       g.setColor(this.my_color);
    else /*!enabled && !fordisplayOnly*/ g.setColor(Color.gray);
    g.fillOval(this.pos.x - guiSize / 2, this.pos.y - guiSize / 2, guiSize, guiSize);
    if (this.selected) {
      g.setColor(Color.red);
      g.drawRect(this.pos.x - guiSize / 2, this.pos.y - guiSize / 2, guiSize, guiSize);
    }
  }
    
  public void run() {
    while(true) {
      try { Thread.sleep(100); } 
      catch(InterruptedException e) {}
      if (enabled) my_behavior.act(inputChannels, outputChannels);
      timeCounter = ++timeCounter % 10000;
    }
  }
}

