/*
 * Main.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 *
 *
 * This is the actual BinSort program, origionally written by 
 * Ben Adida (ben@mit.edu) for Fall '96.  It was exensively rewritten
 * by Todd Parnell (tparnell@ai.mit.edu) for Fall '97.
 */

 
package BinSort;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;

/**
 * Main defines the main(String[]) method.  It sets up the various
 * menus, panels, etc.
 */
public class Main extends Frame {

  private MenuBar menu_bar;
  private Menu binsort_menu, control_menu, selection_menu;
  MenuItem about_item, quit_item, start_item, stop_item, delete_item,
    enable_item, disable_item, load_item, save_item, clear_item,
    configure_item;;
  private Panel top_panel, bottom_panel, center_panel;
  private ControlPanel control_panel;
    
  private Image offscreen_image;
  private Graphics offscreen_graphics;


  public Main(String[] argv) {
    super("Network Simulation");
	
    menu_bar = new MenuBar();
    binsort_menu = new Menu("BinSort");
    control_menu = new Menu("Control");
    selection_menu = new Menu("Selection");
    menu_bar.add(binsort_menu);
    menu_bar.add(control_menu);
    menu_bar.add(selection_menu);
		
    about_item = new MenuItem("About BinSort", new MenuShortcut(KeyEvent.VK_A));
    about_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	new AboutBox();
      }
    });
	
    quit_item = new MenuItem("Quit BinSort", new MenuShortcut(KeyEvent.VK_Q));
    quit_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	Main.this.dispose();
	System.exit(0);
      }
    });
	
    start_item = new MenuItem("Start Simulation", new MenuShortcut(KeyEvent.VK_R));
    stop_item = new MenuItem("Stop Simulation", new MenuShortcut(KeyEvent.VK_P));

    start_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	((SimulationPanel)center_panel).startSimulation();
	Main.this.start_item.setEnabled(false);
	Main.this.stop_item.setEnabled(true);
      }
    });
	
    stop_item.setEnabled(false);
    stop_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	((SimulationPanel)center_panel).stopSimulation();
	Main.this.start_item.setEnabled(true);
	Main.this.stop_item.setEnabled(false);
      }
    });
	
    //	configure_item = new MenuItem("Configure Selection");
    delete_item = new MenuItem("Delete Selection", new MenuShortcut(KeyEvent.VK_X));
    enable_item = new MenuItem("Enable Selection", new MenuShortcut(KeyEvent.VK_E));
    disable_item = new MenuItem("Disable Selection", new MenuShortcut(KeyEvent.VK_D));

    //	configure_item.setEnabled(false);
    //	configure_item.addActionListener(new ActionListener() {
    //	    public void actionPerformed(ActionEvent e) {
    //		((SimulationPanel)center_panel).configureSelection();
    //	    }
    //	});
	
    delete_item.setEnabled(false);
    delete_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	((SimulationPanel)center_panel).deleteSelection();
	Main.this.disable_item.setEnabled(false);
	Main.this.enable_item.setEnabled(false);
	Main.this.delete_item.setEnabled(false);
      }
    });
	
    enable_item.setEnabled(false);
    enable_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	((SimulationPanel)center_panel).enableSelection();
	Main.this.disable_item.setEnabled(true);
	Main.this.enable_item.setEnabled(false);
      }
    });
	
    disable_item.setEnabled(false);
    disable_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	((SimulationPanel)center_panel).disableSelection();
	Main.this.disable_item.setEnabled(false);
	Main.this.enable_item.setEnabled(true);
      }
    });
	
    load_item = new MenuItem("Load Network", new MenuShortcut(KeyEvent.VK_L));
    load_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	loadNetwork();
      }
    });
	
    save_item = new MenuItem("Save Network", new MenuShortcut(KeyEvent.VK_S));
    save_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	saveNetwork();
      }
    });

    clear_item = new MenuItem("Clear Network", new MenuShortcut(KeyEvent.VK_C));
    clear_item.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	((SimulationPanel)center_panel).clearAll();
      }
    });
	
	
    control_panel = new ControlPanel(argv, this);

    // Put in the panels
    bottom_panel = control_panel;
    this.add("South", bottom_panel);

    // Simulation Panel
    center_panel = new SimulationPanel(control_panel);
    this.add("Center", center_panel);
	

    binsort_menu.add(about_item);
    binsort_menu.addSeparator();
    binsort_menu.add(load_item);
    binsort_menu.add(save_item);
    binsort_menu.addSeparator();
    binsort_menu.add(quit_item);

    control_menu.add(start_item);
    control_menu.add(stop_item);
    control_menu.addSeparator();
    control_menu.add(clear_item);

    //	selection_menu.add(configure_item);
    //	selection_menu.addSeparator();
    selection_menu.add(enable_item);
    selection_menu.add(disable_item);
    selection_menu.addSeparator();
    selection_menu.add(delete_item);
    this.setMenuBar(menu_bar);
    this.pack();
    this.show();
    this.setSize(700, 400);
	
    this.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	Main.this.dispose();
	System.exit(0);
      }
    });
  }
	
  public static void main(String argv[]) {
    if (argv.length == 0) {
      argv = new String[1];
      argv[0] = "BinSort.DefaultNodeBehavior";
    }
    new Main(argv);
  }

  /*private*/ void saveNetwork() {

    FileDialog fd = new FileDialog(this, "Save Network As...");
    fd.setMode(fd.SAVE);
    fd.setDirectory(System.getProperty("user.dir"));
	
    //setFilenameFilter not implemented on win32 platform yet...
    //untested on other platforms.
    fd.setFilenameFilter(new FilenameFilter() {
      public boolean accept(File dir, String name) {
	if (name.endsWith(".binsort")) return(true);
	else return( (new File(dir, name)).isDirectory());
      }
    });
	
    fd.show();
	
    try {
      FileOutputStream fos = new FileOutputStream(new File(fd.getDirectory(), fd.getFile()));
	    
      DataOutputStream dos = new DataOutputStream(fos);

      String file_str = "";
      // write out the node types
      for (int i = 0; i < control_panel.nodeNames.length; i++) {
	file_str += control_panel.nodeNames[i] + "\n";
      }

      // the separator
      file_str += "***\n";

      Class[] n_types = control_panel.getClasses(control_panel.nodeNames);

      file_str += ((SimulationPanel)this.center_panel).unparse(n_types);

      try {
	dos.writeBytes(file_str);
	dos.close();
	fos.close();
      }
      catch(IOException e) {}    
    }
    catch(Exception exc) {}

  }
    
  void loadNetwork() {
    FileDialog fd = new FileDialog(this, "Load Network...");
    fd.setMode(fd.LOAD);
    fd.setDirectory(System.getProperty("user.dir"));
	
    //setFilenameFilter not implemented on win32 platform yet...
    //untested on other platforms.
    fd.setFilenameFilter(new FilenameFilter() {
      public boolean accept(File dir, String name) {
	return (name.endsWith(".binsort"));
      }
    });
	
    fd.show();
	
    FileInputStream fis = null;
    try {
      fis = new FileInputStream(new File(fd.getDirectory(), fd.getFile()));
    }
    catch (Exception e) { return; }
	
    InputStreamReader isr = new InputStreamReader(fis);
    BufferedReader br= new BufferedReader(isr);
    String str= null;
    String total_str= "";
    try{
      while (true) {
	str = br.readLine();
	if (str==null) break;
	total_str+= str + "\n";
      }
    }
    catch(IOException e) {
      // error, so nothing happens
      return;
    }
    // split up the string with ***
    StringTokenizer st= new StringTokenizer(total_str,"***");
    if (st.countTokens()!=2) return;
    String node_str= st.nextToken();
    String simulation_str= st.nextToken();

    // split up the node types
    StringTokenizer st2= new StringTokenizer(node_str,"\n");
    String[] n_types= new String[control_panel.nodeNames.length + st2.countTokens()];

    /* Here we have two arrays of strings which we want to combine
     * We want to:
     * - conserve the positions in the array of the old strings
     * - make sure that the references in the file to the new
     * strings are corrected.
     *

     * For making sure that new references are corrected
     * we will use an array of ints
     */

    int[] ref_array= new int[st2.countTokens()];
    // initially, we just offset the indices by the length
    // of the original array.

    int pos= control_panel.nodeNames.length;
    // here we basically want to put together the two arrays.
    for (int i=0; i< control_panel.nodeNames.length; i++) {
      n_types[i]= control_panel.nodeNames[i];
    }
    for (int i=pos; i< n_types.length; i++) {
      String nextitem= st2.nextToken();
      boolean found= false;
      for (int j=0; j<control_panel.nodeNames.length; j++) {
	if (control_panel.nodeNames[j].equals(nextitem)) {
	  found= true;
	  ref_array[i-control_panel.nodeNames.length]= j;
	  break;
	}
      }
      if (!found) {
	n_types[pos]= nextitem;
	ref_array[i-control_panel.nodeNames.length]= pos;
	pos+= 1;
      }
	    
    }

    // HACK FOR 6.096
    for (int i=0; i< ref_array.length; i++) {
      ref_array[i]=i;
    }
	
    // compact the array.
    String[] new_array= new String[pos];
    for (int i=0; i< pos; i++) {
      new_array[i]= n_types[i];
    }
    n_types= new_array;
	
    Class[] n_classes= null;
    try {
      n_classes= control_panel.getClasses(n_types);
    }
    catch(Exception e) {
      return;
    }

	
    ControlPanel new_cp= null;

    // HACK ONLY FOR 6.096 LAB!!
    n_classes= control_panel.getClasses(control_panel.nodeNames);
	
    new_cp = new ControlPanel(control_panel.nodeNames, this);

    // parse the simulation panel
    SimulationPanel new_sp= null;
    try {
      new_sp= SimulationPanel.parse(simulation_str, ref_array, n_classes, new_cp);
    }
    catch(ParseException e) {
      return;
    }

    // replace the elements correctly in the window
    this.setVisible(false);
    this.remove(this.center_panel);
    this.center_panel= new_sp;
    this.add("Center", this.center_panel);
    this.remove(this.bottom_panel);
    this.bottom_panel= new_cp;
    this.add("South",bottom_panel);

    // HACKED OUT FOR 6.096 labs
    // this.node_strings= n_types;
	
    this.pack();
    this.show();
    //	this.setSize(700, 400);
	
    try {
      br.close();
      isr.close();
      fis.close();
    }
    catch(IOException e) {}
  }
}

class AboutBox extends Frame {

  Button ok_button;
    
  public AboutBox() {
    super("About BinSort");
    TextArea ta= new TextArea(80,20);
    ta.setEditable(false);
    ta.setText("This Program works as a very simple network simulation." +
	       "\nIn a later version, it will be extended to include actual" +
	       " routing of \ninformation from one node to another.\n\n" +
	       "This was developed for the MIT 6.096 course, \ntaught by "+
	       "Professor Lynn Stein. \nVersion 1.1 finished September 1997.");
    this.add("Center",ta);

    ok_button= new Button("OK");
    ok_button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	AboutBox.this.setVisible(false);
	AboutBox.this.dispose();
      }
    });
	
    this.add("South",ok_button);

    this.pack();
    this.show();
    this.setSize(400,200);
	
    this.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	AboutBox.this.setVisible(false);
	AboutBox.this.dispose();
      }
    });
  }
}



