/*
 * IntermediateNodeBehavior.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.io.*;
import java.util.Vector;

/**
 * This is an improved version of the IntermediateNode.
 * It does not drop packets and chooses judiciously among
 * availble inputs and outputs.  One feature (bug?) is that
 * there are no sleep statements, and hence sometimes the GUI
 * is dificult to follow.
 * 
 * v1.1 Written by Todd Parnell 8/97
 */
class IntermediateNodeBehavior implements NodeBehavior {

  private boolean               readyToWrite;
  private int                   nextInIndex, nextOutIndex;
  private Object                packetToBeSent;

  private void readFromChannel(Vector inputChannels) {
      
    // If there's no input stream, exit right away.
    if (inputChannels.size() == 0) return;
    for (int i = 0; i < inputChannels.size() && !readyToWrite; i++) {
      try { 
	packetToBeSent = 
	  ((InputChannel)inputChannels.elementAt(nextInIndex)).readObject();
	readyToWrite = true;
      }
      catch(ChannelEmptyException exc) {}
      catch(ChannelDisabledException exc2) {}
      catch(ArrayIndexOutOfBoundsException exc3) {}

      nextInIndex = (nextInIndex + 1) % inputChannels.size();
      // or, if you want to be really grotesque (Todd says cool):
      // nextInIndex = ++nextInputStream % inputChannels.size();
    }
  }


  private void writeToChannel(Vector outputChannels) {

    if (outputChannels.size() == 0) return;
    for (int i = 0; i < outputChannels.size() && readyToWrite; i++) {
      try { 
	((OutputChannel)outputChannels.elementAt(nextOutIndex)).writeObject( packetToBeSent );
	readyToWrite = false;
      } 
      catch(ChannelFullException exc) {}
      catch(ChannelDisabledException exc2) {}
      catch(ArrayIndexOutOfBoundsException exc3) {}

      nextOutIndex = ++nextOutIndex % outputChannels.size();
      // or, if you want to be verbose and clear (Lynn says cool):
      // nextOutIndex = (nextOutIndex + 1) % outputChannels.size();
    }
  }

  public void act(Vector inputs, Vector outputs) {

    if (readyToWrite)           { writeToChannel( outputs ); }
    else /* not readyToWrite */ { readFromChannel( inputs ); }
  }
}


