/*
 * InputChannel.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

/** 
 * This is the interface to recieve objects from a channel.  It defines one
 * method, readObject(). 
 */
public interface InputChannel {

/** 
 * readObject() attempts to return the next availble packet in the channel.
 * The packets generated by our GeneratorNodes are (relatively) uninteresting.
 * Occasionally, readObject() throws an exception, if the Channel is either
 * empty or disabled.  You will have to catch these exceptions in your code.
 */
    public Object readObject() throws ChannelEmptyException, ChannelDisabledException;
}
