/*
 * GeneratorNodeBehavior.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.io.IOException;
import java.util.Vector;

/**
 * This class is the NodeBehavior for GereratorNodes.  It defines the
 * act method.
 */
class GeneratorNodeBehavior implements NodeBehavior {

  private int out_number;
  private int num_created = 0;
  private int spacing = 10;
    
  public void act( Vector inputChannels,
		   Vector outputChannels ) {
		     
    int numInputStreams = inputChannels.size();
    int numOutputStreams = outputChannels.size();
	
    spacing = ++spacing % 10000;

    if ((numOutputStreams == 0) || (spacing  % 10) != 0) return;
	
    out_number = (int)(Math.random() * numOutputStreams);
	    
    try {
      ((OutputChannel)outputChannels.elementAt(out_number)).writeObject(new Object());
      num_created += 1;
    }
    catch(ChannelFullException exc) {}
    catch(ChannelDisabledException exc2) {}
  }
  public int numCreated() { return(num_created); }
    
  public void setFrequency(int freq) {
    if (freq < 1) spacing = 1;
    else if (freq > 50) spacing = 50;
    else spacing = freq;
  }
}
