/*
 * DefaultNodeBehavior.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.util.Vector;

/**
 * This is the default NodeBehavior.  It isn't very good, as it
 * drops packets and generally is unreliable.
 * See IntermediateNode for a good implementation.
 */
class DefaultNodeBehavior implements NodeBehavior {
  
  private Object o = null;
  private int num_attempts = 0;
  private boolean found;
  private int out_number, in_number;
  private int counter;
  
  public void act(Vector inputChannels,
		  Vector outputChannels ) {
    
    int numInputChannels = inputChannels.size();
    int numOutputChannels = outputChannels.size();
    // check to see if we can output this stuff anywhere, and if we have stuff to get!
    if ((numInputChannels == 0) || (numOutputChannels == 0)) { return; }
    
    // randomly decide to not do anything
    if (Math.random() < 0.5) return;
    
    found = false;
    num_attempts = 0;
    
    while(true) {
      num_attempts++;
      if (num_attempts > 20 || found) break;
      in_number = (int)(Math.random() * numInputChannels);
      try { o = ((InputChannel)inputChannels.elementAt(in_number)).readObject(); }
      catch(ChannelEmptyException exc) { continue; }
      catch(ChannelDisabledException exc2) { continue; }
      found = true;
      break;
    }
    
    if (!found) return; 
    found = false;
    num_attempts = 0;
    
    while (true) {
      num_attempts++;
      if (num_attempts > 20 || found) break;;
      out_number = (int)(Math.random() * numOutputChannels);
      try { ((OutputChannel)outputChannels.elementAt(out_number)).writeObject(o); }
      catch(ChannelFullException exc3) { continue; }
      catch(ChannelDisabledException exc4) { continue; }
      found = true;
    }
  }
}


