/*
 * BinSortElement.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */
 
package BinSort;

import java.awt.Graphics;
import java.awt.Point;
/**
 * BinSortElement is an interface implemented by any and all Nodes
 * and/or channels.  It defines the basic methods any element must have.
 * Currently, the list of classes that implement this interface are:
 * Node and Channel.
 */
public interface BinSortElement extends Runnable {

    public void paint(Graphics g);
    
    public void setSelected(boolean b);
    public boolean isSelected();
    
    public void setEnabled(boolean b);
    public boolean isEnabled();
    
    public boolean isInside(Point p);
    public boolean isInside(int x, int y);
    
    public void setDisplayOnly();
    
    public boolean isEditable();
    public void configure();
    
    public void setName(String name);
    public String getName();
    
    public void destroy();
    public void notifyOfDestruction(BinSortElement bse);
}