/*
 * cs101.util.SimpleCanvas
 * $Id: SimpleCanvas.java,v 1.1 1998/06/24 16:32:21 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.awt.*;
import java.awt.event.*;

/**
 * cs101.util.SimpleCanvas is a basic extension to java.awt.Canvas that
 * registers listeners for mouse events and passes the java.awt.Point at
 * which the event occurred to default methods.  These default methods
 * can then be overridden for useful behavior.
 * 
 * @author  Robert Duvall, rcd@cs.duke.edu
 * @author  Todd C. Parnell, tparnell@ai.mit.edu
 * @version $Id: SimpleCanvas.java,v 1.1 1998/06/24 16:32:21 tparnell Exp $ 
 * <br>
 * Copyright 1998 Massachusetts Institute of Technology
 *
 */
public class SimpleCanvas extends Canvas {
	public SimpleCanvas () {
		this.addMouseMotionListener(new MouseMotionListener() {
			public void mouseMoved(MouseEvent e) {
				SimpleCanvas.this.mouseMoved(e.getPoint());
			}
			public void mouseDragged(MouseEvent e){
				SimpleCanvas.this.mouseDragged(e.getPoint());
			}
		});
		
		this.addMouseListener(new MouseListener() {
			public void mousePressed(MouseEvent e) {
				SimpleCanvas.this.mousePressed(e.getPoint());
			}
			public void mouseReleased(MouseEvent e) {
				SimpleCanvas.this.mouseReleased(e.getPoint());
			}
	    public void mouseClicked(MouseEvent e) {
				SimpleCanvas.this.mouseClicked(e.getPoint());
			}
	    public void mouseEntered(MouseEvent e) {
				SimpleCanvas.this.mouseEntered(e.getPoint());
			}
	    public void mouseExited(MouseEvent e) {
		    SimpleCanvas.this.mouseExited(e.getPoint());
			}
		});
	}
	
	// provide reasonable defaults
  public Dimension getMinimumSize() {
		return new Dimension(200, 200);
	}

  public Dimension getPreferredSize () {
		return new Dimension(400,400);
  }
	
	// override the following to provide meaningful reactions
  public void mouseMoved(Point pt) {}
  public void mouseDragged(Point pt) {}   
	public void mousePressed(Point pt) {}
	public void mouseReleased(Point pt) {}
	public void mouseClicked(Point pt) {}
	public void mouseEntered(Point pt) {}
	public void mouseExited(Point pt) {}
}
