/*
 * cs101 producer/consumer (single word) buffer
 * $Id: PNCBuffer.java,v 1.1 1998/03/13 22:18:18 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

/**
 * cs101.util.PNCBuffer implements a producer/consumer synchronized buffer.
 * Interface is pncBuffer.putWord(String), pncBuffer.getNextWord().
 *
 * @see    cs101.util.BS
 *
 * @author  Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: PNCBuffer.java,v 1.1 1998/03/13 22:18:18 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public final class PNCBuffer {
    private String word = null;
    private BS wordRead = new BS(true);
    private BS wordWrite = new BS(false);

   //putWord( String )
   /**
    * (Safely) Puts a word into the PNCBuffer.
    *
    * @param    String    the word to be inserted.
    *
    * @see #getNextWord
    * @see cs101.util.BS
    */
    public void putWord( String newWord ) {
        this.wordWrite.request();
        this.word = newWord;
        this.wordRead.release();
    }

   //getNextWord()
   /**
    * (Safely) Consumes the word held in the PNCBuffer.
    *
    * @return    the word.
    *
    * @see #putWord
    * @see cs101.util.BS
    */
    public String getNextWord() {
        this.wordRead.request();
        String nw = this.word;
        this.wordWrite.release();
        return nw;
    }
}

/* Comments:
 *
 * History:
 *     $Log: PNCBuffer.java,v $
 *     Revision 1.1  1998/03/13 22:18:18  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.3  1996/08/01 18:26:30  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.2  1996/07/30 17:26:00  reuben
 *     Added/corrected javadoc comments.
 *
 *     Revision 1.1.1.1  1996/07/18 17:38:24  sit
 *     Import from /mit/6.096/share/classes after 6.80s session
 *
 *     Revision 1.4  1996/06/19 23:03:02  las
 *     Oops.  Renamed BS's methods to correspond with reality.
 *
 *     6-19-96  Documentation cleaned up by las@ai.mit.edu 
 *     6-18-96  Created by las@ai.mit.edu 
 *
 */
