/*
 * cs101 producer/consumer (single integer) buffer
 * $Id: IntBuffer.java,v 1.1 1998/03/13 22:18:15 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

/**
 * cs101.util.IntBuffer implements a producer/consumer synchronized buffer.<br>
 * Interface is IntBuffer.putButton( int ), IntBuffer.getButton().
 *
 * @see    cs101.util.BS
 *
 * @author  Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: IntBuffer.java,v 1.1 1998/03/13 22:18:15 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public final class IntBuffer {
    private int button;
    private BS buttonRead = new BS(true);
    private BS buttonWrite = new BS(false);

   //putButton( int )
   /**
    * (Safely) Puts a button into the IntBuffer.
    *
    * @param    int    the button to be inserted.
    *
    * @see #getButton
    * @see cs101.util.BS
    */
    public void putButton( int newButton ) {
        this.buttonWrite.request();
        this.button = newButton;
        this.buttonRead.release();
    }

   // getButton()
   /**
    * (Safely) Consumes the button held in the IntBuffer.
    *
    * @return    the button.
    *
    * @see #putButton
    * @see cs101.util.BS
    */
    public int getButton() {
        this.buttonRead.request();
        int b = this.button;
        this.buttonWrite.release();
        return b;
    }
}

/* Comments:
 *
 * History:
 *     $Log: IntBuffer.java,v $
 *     Revision 1.1  1998/03/13 22:18:15  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.3  1996/08/01 18:26:28  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.2  1996/07/30 17:26:00  reuben
 *     Added/corrected javadoc comments.
 *
 *     Revision 1.1.1.1  1996/07/18 17:38:24  sit
 *     Import from /mit/6.096/share/classes after 6.80s session
 *
 *     Revision 1.1  1996/06/25 22:23:36  las
 *     Initial revision
 *
 *     6-25-96  Created by las@ai.mit.edu from PNCBuffer.java
 *
 *     Revision 1.4  1996/06/19 23:03:02  las
 *     Oops.  Renamed BS's methods to correspond with reality.
 *
 *     6-19-96  Documentation cleaned up by las@ai.mit.edu 
 *     6-18-96  Created by las@ai.mit.edu 
 *
 */
