/*
 * cs101.util.GroupDialog
 * $Id: GroupDialog.java,v 1.2 1998/06/24 21:54:14 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/** 
 * dialog box for selecting a new group.
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Mike Wessler, wessler@ai.mit.edu
 *
 * Copyright (c) 1998 Massachusetts Institute of Technology
 *
 */
public class GroupDialog extends Frame implements ActionListener, ItemListener, KeyListener {
  Panel p;
  TextField t;
  Button b;
  Checkbox c;
  ScrollPane s;
  GroupPane g;
  Client gc;
	
  public GroupDialog(Client gc) {
    this.gc = gc;
    this.p = new Panel(new FlowLayout());
    this.t = new TextField("", 30);
    this.b = new Button("Join");
    this.c = new Checkbox("Echo", false);
    this.s = new ScrollPane(ScrollPane.SCROLLBARS_AS_NEEDED);
    this.s.setSize(200, 150);
    this.g = new GroupPane();
    this.setLayout(new FlowLayout());
    this.s.add(g);
    this.b.addActionListener(this);
    this.b.setEnabled(false);
    this.g.addActionListener(this);
    this.c.addItemListener(this);
    this.t.addKeyListener(this);
    this.t.addActionListener(this);
		
    this.p.add(this.c);
    this.p.add(this.b);
    this.add(this.s);
    this.add(this.t);
    this.add(this.p);
    this.setSize(215, 250);
  }
	
  public void parseGroups(String groups) {
    this.g.parseGroups(groups.substring(GroupServer.GROUP_LIST.length()));
  }
	
  public void actionPerformed(ActionEvent evt) {
    if (evt.getSource() == this.b) {
      System.out.println("Join group: " + this.t.getText());
      this.gc.send(GroupServer.JOIN_GROUP + this.t.getText());
    } else if (evt.getSource() == this.t) {
      if (!this.t.getText().equals("")) {
	System.out.println("Join group: " + this.t.getText());
	this.gc.send(GroupServer.JOIN_GROUP + this.t.getText());
      }
    } else {
      this.t.setText(evt.getActionCommand());
      keyTyped(null);
    }
  }
	
  public void keyPressed(KeyEvent evt) {}
  public void keyReleased(KeyEvent evt) {}
  public void keyTyped(KeyEvent evt) {
    if (this.t.getText().equals("")) {
      this.b.setEnabled(false);
    } else {
      this.b.setEnabled(true);
    }
  }
	
  public void itemStateChanged(ItemEvent evt) {
    if (evt.getSource()== this.c) {
      if (evt.getStateChange() == ItemEvent.SELECTED) {
	this.gc.send(GroupServer.WANT_ECHO);
      } else {
	this.gc.send(GroupServer.DONT_ECHO);
      }
    }
  }
}

class GroupPane extends Canvas implements MouseListener {
  Dimension size = new Dimension(180, 20);
  ActionListener actionlistener;
  Vector names;
  int hilite = -1;
	
  public GroupPane() {
    super();
    this.names = new Vector();
    this.addMouseListener(this);
  }
	
  public void addActionListener(ActionListener listener) {
    this.actionlistener = AWTEventMulticaster.add(actionlistener, listener);
  }
	
  public void removeActionListener(ActionListener listener) {
    this.actionlistener= AWTEventMulticaster.remove(actionlistener, listener);
  }
	
  public Dimension getMinimumSize() {
    return this.size;
  }
	
  public Dimension getPreferredSize() {
    return this.size;
  }
	
  public synchronized void parseGroups(String groups) {
    this.names.removeAllElements();
    int loc = 0;
    int end;
    while (loc < groups.length()) {
      end = groups.indexOf("\n", loc);
      if (end == -1) {
	break;
      }
      String name = groups.substring(loc, end);
      this.names.addElement(name);
      loc = end + 1;
    }
    this.setSize(180, names.size()*20);
    this.repaint();
  }
	
  public int mouseOver(Point pt) {
    int which = pt.y / 20;
    if (pt.y < 0 || which >= names.size()) {
      which = -1;
    }
    return which;
  }
	
  public void mousePressed(MouseEvent evt) {
    this.hilite = mouseOver(evt.getPoint());
    this.repaint();
  }

  public void mouseReleased(MouseEvent evt) {
    if (mouseOver(evt.getPoint()) == this.hilite && this.hilite >= 0) {
      if (this.actionlistener != null) {
	String name = (String)this.names.elementAt(this.hilite);
	String group= name.substring(0, name.lastIndexOf(" "));
	this.actionlistener.actionPerformed(
	       new ActionEvent(this, ActionEvent.ACTION_PERFORMED, group));
      }
    } else {
      this.hilite = -1;
    }
    this.repaint();
  }

  public void mouseEntered(MouseEvent evt) {}
  public void mouseExited(MouseEvent evt) {}
  public void mouseClicked(MouseEvent evt) {}
	
  public synchronized void paint(Graphics g) {
    int i;
    for (i = 0; i < names.size(); i++) {
      if (i == this.hilite) {
	g.setColor(Color.lightGray);
	g.fill3DRect(0, i*20, size.width, 20, true);
	g.setColor(Color.blue);
      } else {
	g.setColor(Color.black);
      }
      g.drawString((String)this.names.elementAt(i), 3, 20*i+16);
    }
  }
	
}

/*
 * $Log: GroupDialog.java,v $
 * Revision 1.2  1998/06/24 21:54:14  tparnell
 * code cleanup
 *
 */



