/*
 * cs101.util.GroupClientWire
 * $Id: GroupClientWire.java,v 1.2 1998/06/24 21:42:37 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.io.*;
import java.net.*;

/** 
 * A client that connects to one of many groups on a central server.
 * This client only knows how to send strings.
 * 
 * @see GroupServer
 * @see Client
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Mike Wessler, wessler@ai.mit.edu
 *
 * Copyright (c) 1998 Massachusetts Institute of Technology
 *
 */
public class GroupClientWire extends Client implements Wire
{
  /** 
   *The group dialog box.  If this variable is null, we're in
   * client mode.  If this variable is not null, then we're in
   * selection mode.
   */
  GroupDialog gd  = null;
  String userID   = null;
  GroupWatcher gw = null;

  public String getUserID() {
    return this.userID;
  }
	
  public void writeObject(Object obj) {
    this.send(obj.toString());
  }
	
  public GroupClientWire(String hostname, int port) {
    super(hostname, port);
    init();
  }

  public GroupClientWire(String hostname, int port, GroupWatcher gw) {
    super(hostname, port);
    this.gw = gw;
    init();
  }
	
  public GroupClientWire() {
    super("18.62.4.201", 8870);
    init();
  }
	
  public GroupClientWire(GroupWatcher gw) {
    super("18.62.4.201", 8870);
    this.gw = gw;
    init();
  }
	
  private void init() {
    this.gd = new GroupDialog(this);
    this.gd.show();
    send(GroupServer.GET_GROUPS);
  }

  protected void connectTo( String hostName, int port ) {
    System.out.println("Client:  trying to connect to " + hostName + 
		       " on port " + port );
    try {
      this.sock = new Socket( hostName, port );
      this.is = new DataInputStream( this.sock.getInputStream() );
      this.os = new DataOutputStream( this.sock.getOutputStream() );
    } catch (IOException e) {
      throw new RuntimeException("Client:  " +
				 "can't establish communication with " + 
				 hostName + " on port " + port );
    }
  }

	
  /** 
   * read strings from the server.  These strings will either be
   * processed in this method (if we're in selection mode) or they
   * will be passed off to the stringHandler.
   * 
   * @see Client#stringHandler
   * @see StringHandler#handleString(String) 
   */
  public Object readObject() {
    String s;
    try {
      while (true) {
	s = this.is.readUTF();
	if (this.gd != null) {
	  if (s.startsWith(GroupServer.JOINED)) {
	    this.userID = s.substring(GroupServer.JOINED.length());
	    System.out.println("UserID is " + this.userID);
	    this.gd.dispose();
	    this.gd = null;
	  } else if (s.equals(GroupServer.GROUPS_CHANGED)) {
	    this.send(GroupServer.GET_GROUPS);
	  } else if (s.startsWith(GroupServer.GROUP_LIST)) {
	    this.gd.parseGroups(s);
	  } else {
	    System.out.println("Received unknown: '" + s + "'");
	  }
	} else if (s.equals(GroupServer.SELECT_GROUP)) {
	  this.gd = new GroupDialog(this);
	  this.gd.show();
	  this.send(GroupServer.GET_GROUPS);
	} else if (s.startsWith(GroupServer.JOINED)) {
	  if (this.gw != null) {
	    this.gw.userJoined(s.substring(GroupServer.JOINED.length()));
	  }
	} else if (s.startsWith(GroupServer.CLIENT_LEFT)) {
	  if (this.gw != null) {
	    this.gw.userLeft(s.substring(GroupServer.CLIENT_LEFT.length()));
	  }
	} else {
	  return s;
	}
      }
    } catch (IOException e) {
      throw new RuntimeException("Client:  failed to read");
    }
  }

	
}
