/*
 * cs101 Graphical Semaphore 
 * $Id: GraphicalSemaphore.java,v 1.2 1998/06/03 19:40:55 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;
import java.awt.*;

/**
 * cs101.util.GraphicalSemaphore is the abstract super class for both 
 * the GBS (Graphical Binary semaphore) and the GCS 
 * (Graphical Counting semaphore). <br>
 * It provides a common interface for the two sub-classes:
 * gs.request(), gs.release() as well as doing alot of the
 * graphical grunt work.
 * 
 * @see GCS
 * @see GBS
 *
 * @author  Todd C. Parnell, tparnell@ai.mit.edu
 * @author  Joshua R. Brown, reuben@ai.mit.edu 
 * @version $Id: GraphicalSemaphore.java,v 1.2 1998/06/03 19:40:55 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public abstract class GraphicalSemaphore extends Panel {
  /** Number of instances created */
  protected static int InstanceCounter = 0;
  /** my number in the InstanceCount(er) */
  protected int myNumber;
  /** label for the semaphore */	
  protected Label label;
  /** display panel for the semaphore */ 
  protected Panel display;

  /**
   * Creates some of the GUI objects needed by it's subclasses.
   *
   * Creates a panel to display the semaphore in and a label with
   * the text passed.  
   *
   * @param label  A string that will identify the semaphore in the 
   * display.
   */
  public GraphicalSemaphore(String label) {
    super();
    this.label = new Label(label);
    this.myNumber = this.InstanceCounter++;
  }

  /**
   * This method should be Called by the subclass after it's part of the gui
   * setup is complete.
   *
   * It expects the the display Panel has been initialized by the subclss.
   * It Adds the completed gui components to the panel.
   */
  protected void setupGUI() {
    // Graphics setup
    this.add(this.label);
    this.add(this.display);
  }

  /** <i>abstract - must be overidden in subclass</i> */  
  protected abstract void showStatus();
  /** <i>abstract - must be overidden in subclass</i> */  
  public abstract void request();
  /** <i>abstract - must be overidden in subclass</i> */  
  public abstract void release();

  /**
   * Determines the mininum size necessary for this component.
   * Called by this objects container.
   *
   * @return the minimum size of the object
   */
  public Dimension getMinimumSize() {
    Dimension sizeOfLabel = this.label.getMinimumSize();
    Dimension sizeOfDisplay = this.display.getMinimumSize();
    
    // see which has the greater height
    if (sizeOfDisplay.height >= sizeOfLabel.height)       
      return new Dimension(sizeOfLabel.width
			   +sizeOfDisplay.width+15,
			   sizeOfDisplay.height);
    else 
      return new Dimension(sizeOfLabel.width
			   +sizeOfDisplay.width+15,
			   sizeOfDisplay.height);
  }

  /**
   * Determines the preferedSize necessary for this component.
   * Called by this objects container.
   *
   * @return the preferred size of the object
   */
  public Dimension getPreferredSize() {
    Dimension sizeOfLabel = this.label.getPreferredSize();
    Dimension sizeOfDisplay = this.display.getPreferredSize();
    
    // see which has the greater height
    if (sizeOfDisplay.height >= sizeOfLabel.height)       
      return new Dimension(sizeOfLabel.width
			   +sizeOfDisplay.width+15,
			   sizeOfDisplay.height+15);
    else 
      return new Dimension(sizeOfLabel.width
			   +sizeOfDisplay.width+15,
 			   sizeOfDisplay.height+15);
  }  
   
}

/* Comments:
 *
 * History:
 *     $Log: GraphicalSemaphore.java,v $
 *     Revision 1.2  1998/06/03 19:40:55  tparnell
 *     update from Java 1.0 to 1.1
 *
 *     Revision 1.1  1998/03/13 22:18:14  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.5  1996/08/02 23:37:02  reuben
 *     Improved javadoc comments.
 *
 *     Revision 1.4  1996/08/01 18:26:27  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.3  1996/08/01 16:19:56  reuben
 *     Fixed javadoc problem with return.
 *
 *     Revision 1.2  1996/07/25 18:27:42  reuben
 *     Added all kinds of comments.
 *     Compiled and tested.
 *
 */





