
/*
 * $Id: FriendlyReader.java,v 1.1 1998/06/08 18:11:53 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;  // should really be cs101.io
import java.io.*;

/**
 * A Reader that has a readln method parallelling println:  doesn't throw an exception.<p>
 *
 * @see      cs101.util.Reader
 * @see      cs101.util.BufferedReader
 * @see      cs101.util.PrintWriter
 *
 * @author   Lynn Andrea Stein, las@ai.mit.edu
 * @version  $Id: FriendlyReader.java,v 1.1 1998/06/08 18:11:53 tparnell Exp $
 * <br>
 * Copyright 1998 Massachusetts Institute of Technology
 *
 */

public class FriendlyReader extends BufferedReader {
	

  /**  Just passes along the underying Reader */
  public FriendlyReader ( Reader in ) {
    super( in );
  }
	
  /**  Adds a readln method paralleling println:  Doesn't throw an exception */
  public String readln() {
    try {
      return super.readLine();
    } catch ( IOException e ) {
      return "A read error occurred.\n";
    }
  }

}


/* Comments:
 *
 * History:
 *     $Log: FriendlyReader.java,v $
 *     Revision 1.1  1998/06/08 18:11:53  tparnell
 *     added files from Lynn
 *
 */
 
