/*
 * cs101 ColorField utility 
 * $Id: ColorField.java,v 1.2 1998/06/03 18:50:49 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.awt.*;

/**
 * cs101.util.ColorField provides a colored rectangle that operates
 * as an awt.component.<p> The color field is setup to have two different
 * states represented by two different colors.  The field can be of any
 * size or color.  
 *
 * @author   Todd C. Parnell, tparnell@ai.mit.edu
 * @author   Joshua R. Brown, reuben@ai.mit.edu
 * @version  $Id: ColorField.java,v 1.2 1998/06/03 18:50:49 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public class ColorField extends Canvas {

  /** determines the color of the field */
  protected boolean state;
  /** size of the field */
  protected Dimension dim;
  /** color when state == true */
  protected Color trueColor;
  /** color when state == false */
  protected Color falseColor;

  // ColorField()
  /**
   * Constructs a rectangular color field with default values
   * for all attibutes.
   * <br>
   * o  Initial state = false <br>
   * o  Dimension = 25 X 25  <br>
   * o  Color when state is true = green <br>
   * o  Color when state is false = red <br>
   */
   public ColorField() {
     this(false, new Dimension(25,25), Color.green, Color.red);
   }

  // ColorField(boolean, Dimension, Color, Color)
  /**
   * Constructs a rectangular colorfield with the passed
   * attributes.
   *
   * @param initState  The initial state of the color field.
   * @param dim        The dimensions of the color field.
   * @param trueColor  The color of the field when the state is true.
   * @param falseColor The color of the field when the state is false.  
   */
   public ColorField(boolean initState, Dimension dim,
                     Color trueColor, Color falseColor) {
     this.state = initState;
     this.dim = dim;
     this.trueColor = trueColor;
     this.falseColor = falseColor;
   }

  // changeState(boolean)
  /**
   * Changes the state of the color field to the value passed in.
   *
   * Changing the state of the field will cause the field to repainted
   * in the appropriate color.  If the state is unchanged nothing happens.
   *
   * @param newState  The new state of the color field.
   */
  public void changeState(boolean newState) {
    if (state != newState) {
      this.state = newState;
      this.repaint();
    }
  }

  /**
   * Draws the color field on the screen in it's current state
   * 
   * @param g The graphics context to paint into.
   */
  public void paint(Graphics g) {
    // draw the outline
    g.setColor(Color.black);
    g.drawRect(0,0,this.dim.width-1,this.dim.height-1);

    // draw the field
    if (this.state) 
      g.setColor(this.trueColor);
    else 
      g.setColor(this.falseColor);
    g.fillRect(2,2,this.dim.width-3,this.dim.height-3);

  }

  /**
   * Called by this object's container
   * to determine the minimum space required by this object. 
   *
   * @return the minimum size of the object
   */
  public Dimension getMinimumSize() {
     return new Dimension(this.dim.width,this.dim.height);
  }

  /**
   * Called by this object's container
   * to determine the minimum space required by this object. 
   *
   * @return  the prefered size of the object
   */	
  public Dimension getPreferredSize() {
    return new Dimension(this.dim.width,this.dim.height);
  }
  
}

/* Comments:
 *
 * History:
 *     $Log: ColorField.java,v $
 *     Revision 1.2  1998/06/03 18:50:49  tparnell
 *     migration from Java 1.0 to Java 1.1.  used deprecated APIs
 *
 *     Revision 1.1  1998/03/13 22:18:10  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.4  1996/08/01 18:26:19  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.3  1996/08/01 16:18:21  reuben
 *     Fixed javadoc problem with return
 *
 *     Revision 1.2  1996/07/25 18:27:41  reuben
 *     Added all kinds of comments.
 *     Compiled and tested.
 *
 */








