/*
 * 
 * $Id: Coerce.java,v 1.3 1998/06/07 16:59:52 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.util.Hashtable;
import java.awt.Color;

/**
 * Coerce implements some coercion utilities for a variety of java
 * classes. <br>
 *
 * This file was created for
 *      <a href="http://www.ai.mit.edu/projects/cs101/">
 *                    Rethinking CS101
 * </a> project of Lynn Andrea Stein's AP Group at the MIT
 * Artificial Intelligence Laboratory.<p>
 *
 * @see      java.lang.String
 * @see      java.lang.Double
 * @see      java.awt.Color
 *
 * @author   Lynn Andrea Stein, las@ai.mit.edu
 * @version  $Id: Coerce.java,v 1.3 1998/06/07 16:59:52 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Technology
 *
 */
public final class Coerce {

   // StringTodouble( String )
   /**
    * Given a string representing a floating point number, returns the
    * corresponding (unwrapped) double.
    *
    * Note:  this is <i>not</i> Double StringToDouble( String ), which
    * would be just Double.valueOf( s );
    *
    * @param    s      A string representing a floating point number.
    * @return   the corresponding (unwrapped) double.
    */
    public static final double StringTodouble( String s ) {
        return Double.valueOf( s ).doubleValue();
    }


    static final Hashtable ColorNameTable = new Hashtable(13); 
                                         // 13 is initial capacity
    static {
        ColorNameTable.put("Black", java.awt.Color.black);
        ColorNameTable.put("Blue", java.awt.Color.blue);
        ColorNameTable.put("Cyan", java.awt.Color.cyan);
        ColorNameTable.put("DarkGray", java.awt.Color.darkGray);
        ColorNameTable.put("Gray", java.awt.Color.gray);
        ColorNameTable.put("Green", java.awt.Color.green);
        ColorNameTable.put("LightGray", java.awt.Color.lightGray);
        ColorNameTable.put("Magenta", java.awt.Color.magenta);
        ColorNameTable.put("Orange", java.awt.Color.orange);
        ColorNameTable.put("Pink", java.awt.Color.pink);
        ColorNameTable.put("Red", java.awt.Color.red);
        ColorNameTable.put("White", java.awt.Color.white);
        ColorNameTable.put("Yellow", java.awt.Color.yellow);
    }

   // StringToColor( String )
   /**
    * Given a string representing the name of one of java's built-in
    * colors, returns the corresponding Color object.
    *
    * @param   s      A string representing a java Color.
    * @return  the corresponding Color object.
    */
    public static final Color StringToColor ( Object colorName ) {
        Object c = Coerce.ColorNameTable.get(colorName);
	if ( c == null ) {
	  return Color.black;
	} else {
	  return (Color) c;
	}
    }

  // NewInstanceByClassname( String )
  /**
   * Given a String representing the name of a class, returns an
   * initilized instance of the corresponding class (as an object).
   * Throws CreationException if the indicated class cannot be
   * instantianted for any reason.
   */
  public static final Object NewInstanceByClassname( String s ) throws CreationException {
    try {
      Class c = Class.forName(s);
      return c.newInstance();
    } catch (Exception e) {
      throw new CreationException(s + " could not be created");
    }
  }

}
/* Comments:
 *
 * History:
 *     $Log: Coerce.java,v $
 *     Revision 1.3  1998/06/07 16:59:52  tparnell
 *     changed name to NewInstanceByClassname
 *
 *     Revision 1.2  1998/06/04 23:18:12  tparnell
 *     added a StringToObject method in Coerce, and a generic Main wrapper so
 *     students can avoid public static void main(String[] argv)
 *
 *     Revision 1.1  1998/03/13 22:18:09  tparnell
 *     Import from server crash.  I think the src and class files match up.
 *
 *     Revision 1.3  1996/08/01 18:26:18  reuben
 *     More javadoc tweaking (hopefully the final pass)
 *
 *     Revision 1.2  1996/07/30 17:25:59  reuben
 *     Added/corrected javadoc comments.
 *
 *     Revision 1.1.1.1  1996/07/18 17:38:24  sit
 *     Import from /mit/6.096/share/classes after 6.80s session
 *
 *     Revision 1.2  1996/07/02 21:47:51  las
 *     Added Color (String name to String) coercions.
 *
 *     Revision 1.1  1996/06/25 22:23:36  las
 *     Initial revision
 *
 * */
