/*
 * cs101 Client Tester
 * $Id: ClientTester.java,v 1.3 1998/06/03 21:55:40 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.io.*;

/**
 * cs101.util.ClientTester is a simple driver for the Client class.
 * It reads lines from System.in, then echoes to System.out and a Client.
 *
 * @see Client
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Lynn Andrea Stein, las@ai.mit.edu
 * @version $Id: ClientTester.java,v 1.3 1998/06/03 21:55:40 tparnell Exp $
 * <br>
 * Copyright 1996 Massachusetts Institute of Techonology
 *
 */
public class ClientTester {

    public static void main( String[] argv ){
	Client c = new Client();
	BufferedReader in = 
	  new BufferedReader(new InputStreamReader(System.in));
	try {
	    while (true) {
		System.out.print(">> ");
		System.out.flush();
		c.send( in.readLine() );
	    }
	} catch (IOException  e) {
	    System.out.println ("Shutting down.");
	}	    
    }
}

/*
 * Comments:
 *
 * History:
 *
 * $Log: ClientTester.java,v $
 * Revision 1.3  1998/06/03 21:55:40  tparnell
 * minor bugfix
 *
 * Revision 1.2  1998/06/03 18:35:04  tparnell
 * added header, javadoc, and history log
 * changed from DataInputStream to BufferedReader, since
 * DataInputStream.readLine() is deprecated in Java 1.1
 *
 */
