/*
 * $Id: ClientDialog.java,v 1.4 1998/06/24 21:27:21 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1996 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */
package cs101.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Manages a top level query dialog box to get hostName and port
 * connection information.  To display the dialog box, use ask(); to
 * extract the hostName or port number, use getHostName or getPort().<p>
 *
 * Relies heavily on QueryDialog.
 *
 * @see QueryDialog
 * @see #ask
 * @see #getHostName
 * @see #getPort
 *
 * @author Todd C. Parnell, tparnell@ai.mit.edu
 * @author Nathan Williams <nathanw@mit.edu>
 * @author Lynn Andrea Stein <las@ai.mit.edu>
 * @version $Id: ClientDialog.java,v 1.4 1998/06/24 21:27:21 tparnell Exp $
 */
public class ClientDialog {
  
  protected QueryDialog qd;
  protected String[] answers, questions;
  
  /**
   * Creates the dialog information.
   * To show the dialog, call ask().
   * To retrieve information, use int getPort().
   */
  public ClientDialog() {
    this.questions = new String[2];
    this.questions[0] = "HostName";
    this.questions[1] = "Port";
    this.answers = new String[2];
    try{ 
      this.answers[0] = InetAddress.getLocalHost().getHostName();
    } catch (UnknownHostException e) {}
    this.answers[1] = "4321";
    this.qd = new QueryDialog("Please enter the server host and port.",
			      questions,
			      answers);
  }

  /**
   * Actually display the query dialog and get the answers from the user.
   *
   * @see getHostName()
   * @see getPort()
   */ 
  public synchronized void ask() {
    this.answers = this.qd.ask();
  }

  /**
   * Return the host machine name from the user.  Not guaranteed to be 
   * sensible if ask hasn't aready been called.
   *
   * @see ask()
   */
  public synchronized String getHostName() {
    return( this.answers[0] );
  }

  /**
   * Return the port number from the user.  Not guaranteed to be sensible
   * if ask hasn't aready been called.
   *
   * @see ask()
   */
  public synchronized int getPort() {
    try {
      return Integer.parseInt( this.answers[1] );
    } catch ( NumberFormatException e ) {
      throw new RuntimeException("Bad port number '"+answers[1]+"'");
    }
  }

}
    
/*
 * $Log: ClientDialog.java,v $
 * Revision 1.4  1998/06/24 21:27:21  tparnell
 * code cleanup
 *
 * Revision 1.3  1998/06/22 21:26:54  tparnell
 * merge from 6004 lab tparnell/rcddisk/cs101/util
 *
 * Revision 1.2  1998/06/03 21:48:42  tparnell
 * update from Java 1.0 to 1.1
 *
 * Revision 1.1  1998/03/13 22:18:06  tparnell
 * Import from server crash.  I think the src and class files match up.
 *
 * Revision 1.1  1996/11/18 17:25:00  las
 * Added revised SharedWhiteboard support classes.  These versions of
 * Client and Server supercede the previous ones and are not directly
 * backwards compatible.  In particular, Server is an instantiable class
 * rather than a primarily static one (use RunServer to run it), and
 * Client uses StringHandler rather than subclassing to specialize it.
 * Line.java just picked up some obscure documentation along the way.
 * Otherwise, classes are direct imports from SharedWhiteboard.
 *
 * Revision 1.5  1996/11/18 16:41:19  las
 * Client, Server, their dependencies (e.g. the Dialogs and their
 * invokers) all work.  ClientTester is a bit awkward in that it doesn't
 * echo received strings until something is read.  Oh, well.
 * Moving them to cs101.util in the next revision.
 *
 * Revision 1.4  1996/11/17 22:28:13  las
 * Everything compiles (now).  Client, Server, ClientDialog, ServerDialog,
 * StringHandler, and RunServer need to be moved to cs101.util.  But
 * first, to test....
 *
 * Revision 1.3  1996/11/17 21:26:53  las
 * Client, ClientDialog writen, not yet tested.
 *
 */

