/*
 * cs101.util.BabySitter.java
 * $Id: BabySitter.java,v 1.3 1998/06/24 21:24:27 tparnell Exp $
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see <a href="http://www.ai.mit.edu/projects/cs101">the
 * CS101 homepage</a> or email <las@ai.mit.edu>.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package cs101.util;

import java.io.*;
import java.net.*;

/**
 * This object handles the io between the server and one client.
 * It has a run method that listens for information and relays it to
 * the server.   It also has a method to send information back to its client.
 *
 * @author Todd C. Panrell, tparnell@ai.mit.edu
 * @version $Id: BabySitter.java,v 1.3 1998/06/24 21:24:27 tparnell Exp $
 *
 * Copyright 1998 Massachusetts Institute of Technology
 *
 */
public class BabySitter implements Runnable {

  /** Server this client is connected to */
  protected Server server;
  /** Animacy that runs this object */
  protected Thread spirit;

  /** Client connection */
  protected Socket sock;
  /** Where to read from client */
  protected DataInputStream is;
  /** Where to write to client */
  protected DataOutputStream os;

  /** 
   * Creates a BabySitter to handle communication with a 
   * client.  Spawns a new thread to handle input from client;
   * sends strings on request.
   * 
   * @param s the client socket of this threads client
   *
   * @see #send
   * @see Server#sendToAllExcept
   */
  protected BabySitter(Socket sock, Server server) {
    System.out.println( "Server:  setting up new connection from " +
			sock.getInetAddress().getHostName() +
			" on port " + sock.getPort() );
    this.sock = sock;
    this.server = server;
    try {
      this.is = new DataInputStream(sock.getInputStream());
      this.os = new DataOutputStream(sock.getOutputStream());
    } catch (IOException e) {
      try { this.sock.close(); } catch ( IOException e2 ) {}
      System.out.println("Server:  socket error in BabySitter");
      this.server.removeBabySitter(this);
      return;
    }
    this.spirit = new Thread( this );
    this.spirit.start();
  }

  /**
   * Sends a String to the client.
   *
   * @param s the String to send
   */
  protected void send(String s) {
    try {
      //	    System.out.println("Server:  sending "+s);
      this.os.writeUTF(s+"\n");
      //	    System.out.println("Server:  successfully sent "+s);
    } catch (IOException e) {       
      System.out.println("Server:  socket error in send");
      this.server.removeBabySitter(this);
    }
  }

  /** 
   * Recieves new info from clients.
   *
   * @see Server#sendToAllExcept
   */
  public void run() {
    System.out.println("Server:  BabySitter running");
    while(true)
      {
	try {
	  String s = is.readUTF();
	  System.out.println( "Server:  just read '" + s +"' from " +
			      this.sock.getInetAddress().getHostName() +
			      ", port " + this.sock.getPort() );

	  if( s == null || s == "" ) {
	    this.server.removeBabySitter(this);
	    return;
	  }
	  this.server.sendToAllExcept(s,this);
		
	} catch (IOException e) {
	  System.out.println("Server:  socket error in run ");
	  this.server.removeBabySitter(this);
	} 			  
      }
  }

  /**
   * Should only be called by Server.
   * User server.removeBabySittter( BabySitter ) instead.
   *
   * @see Server#removeBabySitter
   */
  protected void stop() {
    System.out.println( "Server:  closing connection from " +
			this.sock.getInetAddress().getHostName() +
			" on port " + this.sock.getPort() );
    try {
      this.is.close();
    } catch (IOException e) {}
	
    try {
      this.os.close();
    } catch (IOException e) {}

    try {
      this.sock.close();
    } catch (IOException e) {}

    this.spirit.stop();
  }	    
}

/*
 * $Log: BabySitter.java,v $
 * Revision 1.3  1998/06/24 21:24:27  tparnell
 * added logging to file
 *
 */
