package Scribble;

import java.awt.event.*;
import java.awt.*;

public class Whiteboard extends Frame {
    private SmartCanvas drawingArea;
    protected Button clearButton;
    protected Choice colorChoice;
    
    public Whiteboard() {
	this(new SmartCanvas());
    }

    public Whiteboard(SmartCanvas drawingArea) {
	this.drawingArea = drawingArea;
	this.clearButton = new Button ("Clear");
	
	this.colorChoice = new Choice ();
	this.colorChoice.addItem("Black");
	this.colorChoice.addItem("Red");
	this.colorChoice.addItem("Green");
	this.colorChoice.addItem("Blue");
	this.colorChoice.addItem("Yellow");
	this.colorChoice.addItem("Cyan");
	this.colorChoice.addItem("Magenta");
	this.colorChoice.addItem("White");
	this.colorChoice.addItem("Orange");
	this.colorChoice.addItem("Pink");

	this.colorChoice.select("Black");

	this.setTitle("CS101 Scribbler");
    }
    
    public void init() {
        this.setLayout( new BorderLayout(10, 10)); 
	// (#s are gaps between components)

	// all control widgets go in buttonArea (to simplify layout)
	Panel buttonArea = new Panel();
	buttonArea.setLayout(new FlowLayout());
	buttonArea.add( this.colorChoice );
	buttonArea.add( this.clearButton );
	this.add("North", buttonArea );

	this.add("Center", this.drawingArea );

	this.addWindowListener(new WindowListener() {
	    public void windowClosing(WindowEvent we) {
		Whiteboard.this.setVisible(false);		    
		Whiteboard.this.dispose();
		System.exit(0);
	    } 
	    
	    public void windowActivated(WindowEvent we) {}	
	    public void windowClosed(WindowEvent we) {} 
	    public void windowDeactivated(WindowEvent we) {} 
	    public void windowDeiconified(WindowEvent we) {} 
	    public void windowIconified(WindowEvent we) {}
	    public void windowOpened(WindowEvent we) {}
	});
		
	this.pack();
	this.validate();
	this.show();

    }
}
    
