/*
 * ChaseCanvas.java
 * Part of the Chase problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1998 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package Chase;

import cs101.util.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ChaseCanvas extends SimpleCanvas implements GroupWatcher, Runnable {
	
  private final GroupClientWire ccw;
  private final String myID;
  private Point pos;
  private Hashtable myHashtable;
  private boolean painted = true;

  public ChaseCanvas() {
    super();
    this.ccw = new GroupClientWire(this);
    this.myHashtable = new Hashtable();
    this.myID = this.ccw.getUserID();
    new Thread(this).start();
  }
	
  public void run() {
    Point p;
    while (true) {
      try {

	// grab the new string from the wire and parse into our expected
	// tokens.  we expect something of the form "<UID> <X> <Y>"
	String s = (String)this.ccw.readObject();
	StringTokenizer st = new StringTokenizer(s);
	if (st.countTokens() != 3) continue;         // abort if misformatted
	String userID = st.nextToken();
	int x = Integer.parseInt(st.nextToken());
	int y = Integer.parseInt(st.nextToken());
	p = (Point)this.myHashtable.get(userID);

	// figure out whether we've seen this particular user before and
	// either update the point or add a new one
	if (p != null) {
	  p.x = x;
	  p.y = y;
	} else {
	  p = new Point(x, y);
	  System.out.println("New user " + userID + " seen.");
	  this.myHashtable.put(userID, p);
	}

	// redraw
	this.painted = false;
	this.repaint();
	Thread.yield();
      } catch (Exception e) {
	// errors aren't handled particurally gracefully
	System.out.println("Oops.");
      }
    }
  }
	
  public void userJoined(String ID) {
    // the GroupWatcher interface requires us to have this method.  in
    // our case, we simply ignore these messages.
  }
	
  public void userLeft(String userID) {
    // another GroupWatcher method.  
    this.myHashtable.remove(userID);
    System.out.println("User " + userID + " left.");
    this.repaint();
  }
	
  public void mouseMoved(Point p) {
    // overrides SimpleCanvas.mouseMoved
    this.pos = p;
    if (ccw.getUserID()!=null && painted) {
      this.ccw.writeObject(ccw.getUserID() + " " + p.x + " " + p.y);
    }
    painted= false;
    this.repaint();
  }
	
  public void paint(Graphics g) {
    g.setColor(Color.black);
    g.fillOval(this.pos.x, this.pos.y, 20, 20);
    g.setColor(Color.red);
    Enumeration enum = this.myHashtable.keys();
    while (enum.hasMoreElements()) {
      Point p = (Point)(this.myHashtable.get(enum.nextElement()));
      g.fillOval(p.x, p.y, 20, 20);
    }
    painted = true;
  }
}













