package CatAndMouse;

import java.io.*;
import java.net.*;
import cs101.util.Wire;

public class Server implements Wire {

    private Socket mySocket;
    private ServerSocket mySS;
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private ObjectOutputStream myOOS;
    private ObjectInputStream myOIS;

    private int portNumb;
    
    public Server() {
	ServerDialog sd = new ServerDialog();
	
	System.out.println ("Popping up Server Dialog");
	sd.ask();
	portNumb = sd.getPort();
	
	System.out.println ("Trying to create ServerSocket");
	try {
	    mySS = new ServerSocket(portNumb);
	} catch (IOException e) {
	    System.out.println ("Couldn't create ServerSocket");
	    System.exit(0);
	}

	System.out.println ("Waiting for connection.");
	try {
	    mySocket = mySS.accept();
	} catch (IOException e) {
	    System.out.println ("IO exception creating socket");
	    System.exit(0);
	}

	System.out.println ("Trying to create inputStream");
	try {
	    myInputStream = mySocket.getInputStream();
	} catch (IOException e) {
	    System.out.println ("IO Exception creating InputSteam");
	    System.exit(0);
	}

	System.out.println ("Trying to create outputStream.");
	try {
	    myOutputStream = mySocket.getOutputStream();
	} catch (IOException e) {
	    System.out.println ("IO Exception creating OutputStream.");
	    System.exit(0);
	}

	System.out.println ("Trying to create ObjectOutputStream.");
	try {
	    myOOS = new ObjectOutputStream(myOutputStream);
	    myOOS.flush();
	} catch (IOException e) {
	    System.out.println ("Error creating ObjectOutpuStream");
	    System.exit(0);
	}
	
	System.out.println ("Trying to create ObjectInputStream.");
	try {
	    myOIS = new ObjectInputStream(myInputStream);
	} catch (IOException e) {
	    System.out.println ("Error creating ObjectInputStream");
	    System.exit(0);
	}

	System.out.println ("Done.");
    }

    public void writeObject (Object obj) {
	try {
	    myOOS.writeObject(obj);
	} catch (InvalidClassException e) {
	    System.out.println ("Something is wrong w/ the class you sent.");
	} catch (NotSerializableException e) {
	    System.out.println ("Object doesn't implement Serializable");
	} catch (IOException e) {
	    System.out.println ("IO Exception thrown");
	}
    }

    public Object readObject() {
	Object obj = null;
	
	try {
	    obj = myOIS.readObject();
	} catch (ClassNotFoundException e) {
	    System.out.println ("Couldn't find class of Object");
	} catch (InvalidClassException e) {
	    System.out.println ("Oops.");
	} catch (StreamCorruptedException e) {
	    System.out.println ("Uh oh.");
	} catch (OptionalDataException e) {
	    System.out.println ("Sending primitives again, huh Bob/");
	} catch (IOException e) {
	    System.out.println ("Error");
	}

	return obj;
    }
}



