package CatAndMouse;

import java.awt.*;
import java.awt.event.*;
import cs101.util.*;

public class MousePanel extends Panel {
    /* This class creates a Panel that handles GUI. In addition to
       updating and redrawing the location of the Mouse, it also sends
       data out to the Cat over the Wire. */

    private int mouseX = 0;
    private int mouseY = 0;

    private int catX = 0;
    private int catY = 0;
    
    private Wire myWire;
	// I use the wire to send my coords to the Cat.

    public MousePanel (Wire theWire) {
		myWire = theWire;
	this.addMouseMotionListener(new MouseMotionListener() {
	    public void mouseMoved(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
		
		// Whenever the mouse is moved a new packet is created and
		// sent to the Cat.

		mouseX = x;
		mouseY = y;
		
		myWire.writeObject (new Packet (Packet.MOUSELOC,x,y));
		
		repaint();
		
	    }

	    public void mouseDragged(MouseEvent e) {}
	});		
    }

    //The following two methods help the AWT to display this Panel correctly.
    
    public Dimension getMinimumSize() {
	return new Dimension (200, 200);
    }

    public Dimension getPreferredSize () {
	return new Dimension (400,400);
    }
    
    public synchronized void paint (Graphics g) {
	// I shift the coordinates so that the coordinates are in the
	// middle of the dot.

	g.setColor (Color.red);
	g.fillOval (mouseX-MouseDemo.MOUSESIZE/2,
		    mouseY-MouseDemo.MOUSESIZE/2,
		    MouseDemo.MOUSESIZE, MouseDemo.MOUSESIZE);

	g.setColor (Color.black);
	g.fillOval (catX-MouseDemo.CATSIZE/2, catY-MouseDemo.CATSIZE,
		    MouseDemo.CATSIZE, MouseDemo.CATSIZE);
	
    }

    public synchronized void setCatCoords (int x, int y) {
	catX = x;
	catY = y;
    }
    
} // class







