/*
 * TerminatorNodeBehavior.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Color;
import java.io.IOException;
import java.util.Vector;

/**
 * This class is the NodeBehavior for a TerminatorNode.
 */
class TerminatorNodeBehavior implements NodeBehavior {	
  int num_des = 0;
    
  public TerminatorNodeBehavior() {}

  public void act(Vector inputChannels,
		  Vector outputChannels ) {
    int numInputChannels = inputChannels.size();
    int numOutputChannels = outputChannels.size();

    int in_number;
    boolean found = false;
    Object o;

    // If no inputs 
    if (numInputChannels == 0) return;

    // sometimes, just bail
    if (Math.random() < 0.6) return;
	
    for (int i = 0; i < 20; i++) {
      in_number = (int)(Math.random() * numInputChannels);
      try {
	o = ((InputChannel)inputChannels.elementAt(in_number)).readObject();
	num_des += 1;
      }
      catch(ChannelEmptyException exc) { return; }
      catch(ChannelDisabledException exc2) { return; }
    }
  }
    
  public int numDestroyed() { return(num_des); }
}
