/*
 * OutputChannel.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

/** 
 * This is the interface to put objects into a channel.  It defines one
 * method, writeObject(). 
 */
public interface OutputChannel {

/** 
 * writeObject() attempts to place its argument in the channel.  You can place any
 * object into a channel, though you probably only want to deal with the packets
 * Generators create.  writeObject occasionly throws exceptions, if the channel you
 * try to write to is either full or disabled.
 */
    public void writeObject(Object o) throws ChannelFullException, ChannelDisabledException;
}
