/*
 * NodeBehavior.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.util.Vector;

/**
 * NodeBehavior is the interface you must implement in your code.  It
 * defines a single method, act. 
 */
public interface NodeBehavior {

/** act is the method you will write for this lab.  It has two
 * arguments, both Vectors, corresponding to the inputs and outputs
 * availble to you.  Note that the elements passed are availble, but
 * perhaps disabled, full, or empty.  You will need to be careful for
 * these conditions.  act is called repeatedly by a node from within a
 * while (true) {} loop.  You should only deal with a single task on
 * each iteration...leave the looping to the node.  */
    public void act( Vector  inputChannels,
		     Vector outputChannels );
}
